import java.util.Scanner;

public class Main {
    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);
        int N = sc.nextInt();
        int M = sc.nextInt();

        int[] A = new int[M];
        int[] B = new int[M];

        for (int i = 0; i < M; i++) {
            A[i] = sc.nextInt();
            B[i] = sc.nextInt();
        }

        int need = M / 2;

        int[] best = new int[N + 1];
        int bestSat = -1;

        for (int iter = 0; iter < 2000; iter++) {

            int[] color = new int[N + 1];

            for (int i = 1; i <= N; i++) {
                if (Math.random() < 0.5) color[i] = 1;
                else color[i] = 2;
            }

            int sat = 0;

            for (int i = 0; i < M; i++) {
                if (color[A[i]] != color[B[i]]) sat++;
            }

            if (sat > bestSat) {
                bestSat = sat;
                for (int i = 1; i <= N; i++) best[i] = color[i];
            }
        }

        if (bestSat < need) {
            System.out.println("-1");
            return;
        }

        int count1 = 0;
        int count2 = 0;

        for (int i = 1; i <= N; i++) {
            if (best[i] == 1) count1++;
            else count2++;
        }

        System.out.println(count1 + " " + count2);

        for (int i = 1; i <= N; i++) {
            if (best[i] == 1) System.out.print(i + " ");
        }
        System.out.println();

        for (int i = 1; i <= N; i++) {
            if (best[i] == 2) System.out.print(i + " ");
        }
        System.out.println();
    }
}