#include <iostream>
#include <cstdlib>
#include <ctime>
using namespace std;



static int A[2000000], B[2000000];
static int adj[1001][1001];
static int deg[1001];
static int team[1001];

int evaluate(int M) {
    int cut = 0;
    for (int i = 0; i < M; i++)
        if (team[A[i]] != team[B[i]])
            cut++;
    return cut;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int N, M;
    cin >> N >> M;

    for (int i = 1; i <= N; i++)
        deg[i] = 0;

    
    for (int i = 0; i < M; i++) {
        cin >> A[i] >> B[i];
        int u = A[i], v = B[i];

        
        adj[u][deg[u]++] = v;
        adj[v][deg[v]++] = u;
    }

    int need = M / 2;  

    srand(time(NULL));

    
    for (int attempt = 0; attempt < 20; attempt++) {

        
        for (int i = 1; i <= N; i++)
            team[i] = rand() % 2;

        int cut = evaluate(M);

        
        bool improved = true;
        while (improved) {
            improved = false;

            for (int v = 1; v <= N; v++) {
                int same = 0, diff = 0;

               
                for (int j = 0; j < deg[v]; j++) {
                    int u = adj[v][j];
                    if (team[v] == team[u]) same++;
                    else diff++;
                }

                
                if (same > diff) {
                    cut += same - diff;
                    team[v] ^= 1;
                    improved = true;
                }
            }
        }

        
        if (cut >= need) {
            int c0 = 0, c1 = 0;

            for (int i = 1; i <= N; i++)
                if (team[i] == 0) c0++;
                else c1++;

            
            cout << c0 << " " << c1 << "\n";

            
            for (int i = 1; i <= N; i++)
                if (team[i] == 0) cout << i << " ";
            cout << "\n";

            
            for (int i = 1; i <= N; i++)
                if (team[i] == 1) cout << i << " ";
            cout << "\n";

            return 0;
        }
    }

    
    cout << -1 << "\n";
    return 0;
}