#include <bits/stdc++.h>
using namespace std;

vector<int> g[500005];
int comp[500005];

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int T;
    cin >> T;

    while (T--) {
        int n, m;
        cin >> n >> m;

        vector<long long> k(n);
        for (int i = 0; i < n; i++) cin >> k[i];

        vector<pair<int,int>> e;
        e.reserve(m);

        for (int i = 0; i < n; i++) g[i].clear();
        for (int i = 0; i < n; i++) comp[i] = -1;

        for (int i = 0; i < m; i++) {
            int a, b;
            cin >> a >> b;
            e.push_back({a, b});
            g[a].push_back(b);
            g[b].push_back(a); 
        }

        int cid = 0;
        for (int i = 0; i < n; i++) {
            if (comp[i] == -1) {
                queue<int> q;
                q.push(i);
                comp[i] = cid;
                while (!q.empty()) {
                    int u = q.front(); q.pop();
                    for (int v : g[u]) {
                        if (comp[v] == -1) {
                            comp[v] = cid;
                            q.push(v);
                        }
                    }
                }
                cid++;
            }
        }

        vector<long long> sum(cid, 0);
        vector<int> ok(cid, 1);

        for (int i = 0; i < n; i++) sum[comp[i]] += k[i];
        for (auto &x : e) {
            int a = x.first;
            int b = x.second;
            if (comp[a] != comp[b]) {
                ok[comp[a]] = 0;
            }
        }

        long long ans = -1;

        for (int i = 0; i < cid; i++) {
            if (ok[i] && sum[i] > 0)
                ans = max(ans, sum[i]);
        }

        cout << ans << "\n";
    }

    return 0;
}