#include <stdio.h>
#include <stdlib.h>

int cmp(const void *a, const void *b) {
    long long x = *(long long*)a;
    long long y = *(long long*)b;
    return (x > y) - (x < y);
}

int main() {
    int N, M;
    scanf("%d %d", &N, &M);

    long long *A = malloc(sizeof(long long) * M);
    for (int i = 0; i < M; i++) {
        scanf("%lld", &A[i]);
    }

    qsort(A, M, sizeof(long long), cmp);

    long long base = 0;
    for (int i = 0; i < N - 1; i++) {
        base += A[i];
    }

    long long ans = base;
    if (M > N - 1) {
        long long candidate = base - A[0] + A[M - 1];
        if (candidate > ans)
            ans = candidate;
    }

    printf("%lld\n", ans);

    free(A);
    return 0;
}