using System;
using System.Collections.Generic;
using System.Linq;

namespace PaintballTimskaPodela
{
    public class Program
    {
        public static void Main(string[] args)
        {
            // --- ????????? ????? ---
            
            // ?????? ???? ?????? (N ? M)
            if (!TryReadLineOfInts(out int N, out int M))
            {
                // ? ??????? ?? ???? ?????, ?????????
                return;
            }

            // ????????? ???? ? ???? (?????? ???????)
            // ??????? ?? ??????????? ?? 1 ?? N.
            // ????? (int, int) ?? ?????? ?????? (A, B)
            var zelje = new List<(int A, int B)>();
            for (int i = 0; i < M; i++)
            {
                if (TryReadLineOfInts(out int A, out int B))
                {
                    zelje.Add((A, B));
                }
            }

            // --- ????????? ??????????? ?????? ---

            // 1. ?????????? ?????? ????????? ??????????? ???????
            var timA = new List<int>();
            var timB = new List<int>();

            for (int i = 1; i <= N; i++)
            {
                // ??????? ?? ???????? ID (1, 3, 5...) ??? ? ??? ?
                if (i % 2 != 0)
                {
                    timA.Add(i);
                }
                // ??????? ?? ?????? ID (2, 4, 6...) ??? ? ??? ?
                else
                {
                    timB.Add(i);
                }
            }
            
            // --- ?????????? ?? ???? ??????? ???? ---
            // ????????? HashSet ?? ???? ??????? ??????????? ????
            var timASet = new HashSet<int>(timA);
            var timBSet = new HashSet<int>(timB);

            // 2. ???????????? ????????? ????
            int ispunjeneZelje = PrebrojIspunjenje(zelje, timASet, timBSet);

            // 3. ??????? ?????? (?????????? ??????)
            int minimalanUslov = M / 2; // (floor(M/2))

            // 4. ?????????? ??????
            if (ispunjeneZelje >= minimalanUslov)
            {
                // ?????? (??? ?, ??? ?) ?? ?????
                IspisiPodelu(timA, timB);
            }
            else
            {
                // ?????? (??? ?, ??? ?) ?? ??????????? ???? (M - X), ?? ?? ?????????
                IspisiPodelu(timB, timA);
            }
        }

        /// <summary>
        /// ?????????? ?????? ?? ???? ???????? ?? ???? ?????? ??????.
        /// ???? ?? ???????? ??? ??????? ???? ???? ? ????? ????.
        /// </summary>
        private static int PrebrojIspunjenje(List<(int A, int B)> zelje, HashSet<int> tim1, HashSet<int> tim2)
        {
            int brojac = 0;
            foreach (var zelja in zelje)
            {
                int clan1 = zelja.A;
                int clan2 = zelja.B;

                // ??????????? ?? ?? ?? ??????? ? ?????????? ????????:
                // ? ???? 1 ??? ? ???? 2
                bool clan1UTimu1 = tim1.Contains(clan1);
                bool clan2UTimu1 = tim1.Contains(clan2);

                // ???????? ??? ????? ????? ? ???? 1, ? ????? ???? ? ???? 1 (??. ? ???? 2)
                if (clan1UTimu1 != clan2UTimu1) 
                {
                    brojac++;
                }
            }
            return brojac;
        }

        /// <summary>
        /// ???????? ???????? ? ???????? ???????.
        /// </summary>
        private static void IspisiPodelu(List<int> timP, List<int> timD)
        {
            // ???? ??????: P D (???????? ??????)
            Console.WriteLine($"{timP.Count} {timD.Count}");

            // ????? ??????: ??????? ???? P
            Console.WriteLine(string.Join(" ", timP.OrderBy(x => x)));

            // ????? ??????: ??????? ???? D
            Console.WriteLine(string.Join(" ", timD.OrderBy(x => x)));
        }

        /// <summary>
        /// ??????? ?????? ?? ??????? ?????? ??? ???? ????? ?? ????? ??????.
        /// </summary>
        private static bool TryReadLineOfInts(out int first, out int second)
        {
            first = 0;
            second = 0;
            string line = Console.ReadLine();
            if (string.IsNullOrWhiteSpace(line))
            {
                return false;
            }

            var parts = line.Split(new[] { ' ' }, StringSplitOptions.RemoveEmptyEntries);
            if (parts.Length < 2)
            {
                return false;
            }

            if (int.TryParse(parts[0], out first) && int.TryParse(parts[1], out second))
            {
                return true;
            }

            return false;
        }
    }
}