#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>

#define MAXN 505
#define MAXM 1000005
#define INF 1000000000000000000LL

/* ---------- Graph for SCC ---------- */
typedef struct {
    int to, next;
} Edge;

Edge g[MAXM], gr[MAXM];
int head[MAXN], headr[MAXN];
int ec, ecr;

void add_edge(int *h, Edge *ed, int *cnt, int u, int v) {
    ed[*cnt].to = v;
    ed[*cnt].next = h[u];
    h[u] = (*cnt)++;
}

/* ---------- SCC ---------- */
int n, m;
int used[MAXN], comp[MAXN], order[MAXN], ordn;
long long K[MAXN];

void dfs1(int v) {
    used[v] = 1;
    for (int i = head[v]; i != -1; i = g[i].next)
        if (!used[g[i].to])
            dfs1(g[i].to);
    order[ordn++] = v;
}

void dfs2(int v, int c) {
    comp[v] = c;
    for (int i = headr[v]; i != -1; i = gr[i].next)
        if (comp[gr[i].to] == -1)
            dfs2(gr[i].to, c);
}

/* ---------- Dinic ---------- */
typedef struct {
    int to, rev;
    long long cap;
} FlowEdge;

FlowEdge fg[5000];
int fh[2000], fcnt;

void fadd(int u, int v, long long c) {
    fg[fcnt] = (FlowEdge){v, fcnt ^ 1, c};
    fh[u] = fcnt++;
    fg[fcnt] = (FlowEdge){u, fcnt ^ 1, 0};
    fh[v] = fcnt++;
}

int level[2000], it[2000];

int bfs(int s, int t) {
    memset(level, -1, sizeof(level));
    int q[2000], l = 0, r = 0;
    level[s] = 0;
    q[r++] = s;
    while (l < r) {
        int v = q[l++];
        for (int i = fh[v]; i != -1; i = fg[i].rev) {
            FlowEdge *e = &fg[i];
            if (e->cap > 0 && level[e->to] < 0) {
                level[e->to] = level[v] + 1;
                q[r++] = e->to;
            }
        }
    }
    return level[t] >= 0;
}

long long dfs(int v, int t, long long f) {
    if (!f || v == t) return f;
    for (int *i = &it[v]; *i != -1; *i = fg[*i].rev) {
        FlowEdge *e = &fg[*i];
        if (e->cap > 0 && level[e->to] == level[v] + 1) {
            long long pushed = dfs(e->to, t, f < e->cap ? f : e->cap);
            if (pushed) {
                e->cap -= pushed;
                fg[e->rev].cap += pushed;
                return pushed;
            }
        }
    }
    return 0;
}

long long maxflow(int s, int t) {
    long long flow = 0;
    while (bfs(s, t)) {
        memcpy(it, fh, sizeof(fh));
        while (1) {
            long long pushed = dfs(s, t, INF);
            if (!pushed) break;
            flow += pushed;
        }
    }
    return flow;
}

/* ---------- Main ---------- */
int main() {
    int T;
    scanf("%d", &T);

    while (T--) {
        scanf("%d %d", &n, &m);

        for (int i = 0; i < n; i++)
            scanf("%lld", &K[i]);

        memset(head, -1, sizeof(head));
        memset(headr, -1, sizeof(headr));
        ec = ecr = 0;

        for (int i = 0; i < m; i++) {
            int a, b;
            scanf("%d %d", &a, &b);
            add_edge(head, g, &ec, a, b);
            add_edge(headr, gr, &ecr, b, a);
        }

        memset(used, 0, sizeof(used));
        ordn = 0;
        for (int i = 0; i < n; i++)
            if (!used[i]) dfs1(i);

        memset(comp, -1, sizeof(comp));
        int csz = 0;
        for (int i = n - 1; i >= 0; i--)
            if (comp[order[i]] == -1)
                dfs2(order[i], csz++);

        long long w[csz];
        memset(w, 0, sizeof(w));
        for (int i = 0; i < n; i++)
            w[comp[i]] += K[i];

        memset(fh, -1, sizeof(fh));
        fcnt = 0;
        int S = csz, Tt = csz + 1;

        long long posSum = 0;
        for (int i = 0; i < csz; i++) {
            if (w[i] > 0) {
                fadd(S, i, w[i]);
                posSum += w[i];
            } else if (w[i] < 0) {
                fadd(i, Tt, -w[i]);
            }
        }

        for (int u = 0; u < n; u++) {
            for (int i = head[u]; i != -1; i = g[i].next) {
                int v = g[i].to;
                if (comp[u] != comp[v])
                    fadd(comp[u], comp[v], INF);
            }
        }

        long long flow = maxflow(S, Tt);
        long long ans = posSum - flow;

        if (ans > 0) printf("%lld\n", ans);
        else printf("-1\n");
    }

    return 0;
}