#include <bits/stdc++.h>
using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n, m;
    cin >> n >> m;

    vector<vector<int>> adj(n + 1);
    for (int i = 0; i < m; i++) {
        int a, b;
        cin >> a >> b;
        adj[a].push_back(b);
        adj[b].push_back(a);  
    }

    vector<int> color(n + 1, -1); 

    for (int i = 1; i <= n; i++) {
        if (color[i] != -1) continue;

        queue<int> q;
        color[i] = 0;
        q.push(i);

        while (!q.empty()) {
            int u = q.front(); q.pop();
            for (int v : adj[u]) {
                if (color[v] == -1) {
                    color[v] = color[u] ^ 1;
                    q.push(v);
                }
            }
        }
    }

    vector<int> tim1, tim2;
    for (int i = 1; i <= n; i++) {
        if (color[i] == 0) tim1.push_back(i);
        else tim2.push_back(i);
    }

    cout << tim1.size() << " " << tim2.size() << "\n";
    for (int x : tim1) cout << x << " ";
    cout << "\n";
    for (int x : tim2) cout << x << " ";
    cout << "\n";

    return 0;
}