#include <bits/stdc++.h>
using namespace std;
using ll = long long;

ll recursionDFS(int v, vector<vector<int>>& adj, vector<ll>& K, vector<bool>& vis) {
    vis[v] = true;
    ll sum = K[v];

    for (int to : adj[v]) {
        if (!vis[to]) {
            sum += recursionDFS(to, adj, K, vis);
        }
    }
    return sum;
}

ll dfs(vector<vector<int>>& adj, int n, vector<ll>& K) {
    ll res = 0;
    for (int i = 0; i < n; i++) {
        ll t = 0;
        vector<bool> vis(n, false);
        t = recursionDFS(i, adj, K, vis);
        if(t > res){
            res = t;
        }
    }
    if(res == 0){
        return -1;
    }
    return res;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int T;
    cin >> T;
    while (T--) {
        int N, M;
        cin >> N >> M;

        vector<ll> K(N);
        for (int i = 0; i < N; i++) cin >> K[i];

        vector<vector<int>> adj(N);
        for (int i = 0; i < M; i++) {
            int u, v;
            cin >> u >> v;
            adj[u].push_back(v);
        }

        cout << dfs(adj, N, K) << "\n";
    }
    return 0;
}