#include <algorithm>
#include <cstdint>
#include <iostream>
#include <stack>
#include <vector>

using namespace std;

class Node {
    public:

    int liters = 0;
    vector<int> links;

    Node () {
        this -> liters = 0;
    }
};

bool checkIn(const int visited[], const int num, const int x) {
    for (int i = 0; i < num; i++) {
        if (visited[i] == x) return true;
    }

    return false;
}

int findSum(Node nodes[], const int index, const int n) {
    stack<int> links;

    Node curr = nodes[index];
    for (int link : curr.links) links.push(link);

    int sum = curr.liters;

    int numVisited = 1;
    int visited[n];
    visited[0] = index;
    for (int i = 1; i < n; i++) visited[i] = -1;

    while (!links.empty() && numVisited != n) {
        const int currentIndex = links.top();
        links.pop();

        if (checkIn(visited, numVisited, currentIndex)) continue;

        curr = nodes[currentIndex];
        visited[numVisited++] = currentIndex;

        for (int link : curr.links) links.push(link);

        sum += curr.liters;
    }

    if (numVisited == n) return 0;
    return sum;
}

int main() {
    int T;
    cin >> T;

    int values[T];

    for (int testCase = 0; testCase < T; testCase++) {
        int n, m;

        cin >> n >> m;

        Node nodes[n];
        for (int i = 0; i < n; i++) {
            cin >> nodes[i].liters;
        }

        for (int i = 0; i < m; i++) {
            int startIndex, endIndex;

            cin >> startIndex >> endIndex;

            nodes[startIndex].links.push_back(endIndex);
        }

        int maximum = 0;
        for (int i = 0; i < n; i++) {
            int temp = findSum(nodes, i, n);

            if (temp > maximum) maximum = temp;
        }

        if (maximum == 0) values[testCase] = -1;
        else values[testCase] = maximum;
    }

    for (int i = 0; i < T; i++) {
        cout << values[i] << endl;
    }
}