using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
namespace takmicenje
{
    internal class Program
    {
        static int t;
        static List<int>[] graph;
        static List<int>[] revGraph;
        static bool[] visited;
        static Stack<int> stack;
        static int[] component;
        static int N, M;
        static int[] K;

        static void Main()
        {
            t = int.Parse(Console.ReadLine());
            for (int test = 0; test < t; test++)
            {
                var line = Console.ReadLine().Split().Select(int.Parse).ToArray();
                N = line[0];
                M = line[1];

                K = Console.ReadLine().Split().Select(int.Parse).ToArray();

                graph = new List<int>[N];
                revGraph = new List<int>[N];
                for (int i = 0; i < N; i++)
                {
                    graph[i] = new List<int>();
                    revGraph[i] = new List<int>();
                }

                for (int i = 0; i < M; i++)
                {
                    var edge = Console.ReadLine().Split().Select(int.Parse).ToArray();
                    int u = edge[0];
                    int v = edge[1];
                    graph[u].Add(v);
                    revGraph[v].Add(u);
                }

                visited = new bool[N];
                stack = new Stack<int>();
                for (int i = 0; i < N; i++)
                    if (!visited[i])
                        DFS1(i);

                component = new int[N];
                Array.Fill(component, -1);
                int compId = 0;
                visited = new bool[N];
                while (stack.Count > 0)
                {
                    int node = stack.Pop();
                    if (!visited[node])
                    {
                        DFS2(node, compId);
                        compId++;
                    }
                }
                long[] sumK = new long[compId];
                for (int i = 0; i < N; i++)
                    sumK[component[i]] += K[i];
                bool[] hasOutEdge = new bool[compId];
                for (int u = 0; u < N; u++)
                {
                    foreach (var v in graph[u])
                    {
                        if (component[u] != component[v])
                            hasOutEdge[component[u]] = true;
                    }
                }

                long maxQuality = long.MinValue;
                for (int i = 0; i < compId; i++)
                {
                    if (!hasOutEdge[i] && sumK[i] > 0)
                        maxQuality = Math.Max(maxQuality, sumK[i]);
                }

                Console.WriteLine(maxQuality == long.MinValue ? -1 : maxQuality + 1);
            }
        }

        static void DFS1(int u)
        {
            visited[u] = true;
            foreach (var v in graph[u])
                if (!visited[v])
                    DFS1(v);
            stack.Push(u);
        }

        static void DFS2(int u, int id)
        {
            visited[u] = true;
            component[u] = id;
            foreach (var v in revGraph[u])
                if (!visited[v])
                    DFS2(v, id);
        }
    }
}