using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
namespace takmicenje
{
    internal class Program
    {
        static void Main()
        {
            int T = int.Parse(Console.ReadLine());
            List<long> res = new List<long>();
            while (T-- > 0)
            {
                var nm = Console.ReadLine().Split();
                int N = int.Parse(nm[0]);
                int M = int.Parse(nm[1]);
                long[] K = Array.ConvertAll(Console.ReadLine().Split(), long.Parse);
                List<int>[] g = new List<int>[N];
                List<int>[] rg = new List<int>[N];
                for (int i = 0; i < N; i++)
                {
                    g[i] = new List<int>();
                    rg[i] = new List<int>();
                }
                for (int i = 0; i < M; i++)
                {
                    var ab = Console.ReadLine().Split();
                    int a = int.Parse(ab[0]);
                    int b = int.Parse(ab[1]);
                    g[a].Add(b);
                    rg[b].Add(a);
                }
                bool[] vis = new bool[N];
                Stack<int> stack = new Stack<int>();
                List<int> red = new List<int>();

                for (int i = 0; i < N; i++)
                {
                    if (vis[i]) continue;
                    stack.Push(i);
                    while (stack.Count > 0)
                    {
                        int u = stack.Pop();
                        if (u >= 0)
                        {
                            if (vis[u]) continue;
                            vis[u] = true;
                            stack.Push(~u);
                            foreach (var v in g[u])
                                if (!vis[v]) stack.Push(v);
                        }
                        else
                        {
                            red.Add(~u);
                        }
                    }
                }
                int[] cmp = new int[N];
                Array.Fill(cmp, -1);
                int C = 0;
                for (int i = red.Count - 1; i >= 0; i--)
                {
                    int start = red[i];
                    if (cmp[start] != -1) continue;

                    Stack<int> s = new Stack<int>();
                    s.Push(start);
                    cmp[start] = C;

                    while (s.Count > 0)
                    {
                        int u = s.Pop();
                        foreach (var v in rg[u])
                        {
                            if (cmp[v] == -1)
                            {
                                cmp[v] = C;
                                s.Push(v);
                            }
                        }
                    }
                    C++;
                }
                long[] sum = new long[C];
                for (int i = 0; i < N; i++) sum[cmp[i]] += K[i];
                List<int>[] dag = new List<int>[C];
                int[] indeg = new int[C];
                for (int i = 0; i < C; i++) dag[i] = new List<int>();

                for (int u = 0; u < N; u++)
                {
                    foreach (var v in g[u])
                    {
                        int cu = cmp[u], cv = cmp[v];
                        if (cu != cv)
                        {
                            dag[cu].Add(cv);
                            indeg[cv]++;
                        }
                    }
                }
                Queue<int> q = new Queue<int>();
                for (int i = 0; i < C; i++) if (indeg[i] == 0) q.Enqueue(i);

                List<int> topo = new List<int>();
                while (q.Count > 0)
                {
                    int u = q.Dequeue();
                    topo.Add(u);
                    foreach (var v in dag[u])
                    {
                        indeg[v]--;
                        if (indeg[v] == 0) q.Enqueue(v);
                    }
                }
                long[] uk = new long[C];
                for (int i = topo.Count - 1; i >= 0; i--)
                {
                    int u = topo[i];
                    uk[u] = sum[u];
                    foreach (var v in dag[u]) uk[u] += uk[v];
                }

                long ans = -1;
                for (int i = 0; i < C; i++)
                    if (uk[i] > 0) ans = Math.Max(ans, uk[i]);

                res.Add(ans);
            }
            foreach (var r in res) Console.WriteLine(r);
        }
    }
}