# Union-Find struktura za nekakvo grupisanje
# Sve ovo radi globalno, pazite se.

roditelj = []
N = 0
M = 0

def inicijalizujUF(velicina):
    global roditelj, N
    N = velicina
    roditelj = list(range(N + 1))

def nadjiRoditelja(i):
    global roditelj
    if roditelj[i] == i:
        return i
    # Stisnuti put (Path compression) - ovo je brzo
    roditelj[i] = nadjiRoditelja(roditelj[i])
    return roditelj[i]

def ujedini(i, j):
    global roditelj
    rodI = nadjiRoditelja(i)
    rodJ = nadjiRoditelja(j)
    if rodI != rodJ:
        # Spajanje nije bitno, samo ih spoji
        roditelj[rodI] = rodJ
        return True
    return False

# Pomocna funkcija za biranje želja

# Generiše kombinacije indeksa
def generisiKombinacije(k):
    global M
    if k < 0 or k > M:
        return []
    
    indeksi = list(range(k))
    kombinacije = []

    if k == 0:
        return [[]]

    while True:
        # Uzimamo trenutnu kombinaciju
        kombinacije.append(list(indeksi))

        # Povecavamo indekse
        i = k - 1
        while i >= 0 and indeksi[i] == M - k + i:
            i -= 1

        if i < 0:
            break

        indeksi[i] += 1

        # Resetujemo ostale
        for j in range(i + 1, k):
            indeksi[j] = indeksi[j - 1] + 1
            
    return kombinacije

# six sevennnnnn
linija = input().split()
N = int(linija[0])
M = int(linija[1])

zelje = []
for i in range(M):
    linija = input().split()
    A = int(linija[0])
    B = int(linija[1])
    zelje.append((A, B))

KMinimalno = M // 2
KMaksimalnoNeispunjeno = M - KMinimalno

# ovde pocinje glavno

resenjePronadjeno = False

for velicinaNeispunjenih in range(KMaksimalnoNeispunjeno + 1):
    
    skupoviIndeksa = generisiKombinacije(velicinaNeispunjenih)
    
    for SIndeksi in skupoviIndeksa:
        
        inicijalizujUF(N)

        for i in SIndeksi:
            A, B = zelje[i]
            ujedini(A, B) # Ovi moraju biti isti

        PKMapa = {} 
        brojacPK = 0
        for i in range(1, N + 1):
            rod = nadjiRoditelja(i)
            if rod not in PKMapa:
                brojacPK += 1
                PKMapa[rod] = brojacPK
        
        velicinaGrafaRazlika = brojacPK
        
        grafRazlika = [[] for _ in range(velicinaGrafaRazlika + 1)]
        
        validanS = True
        for i in range(M):
            isIspunjena = True
            for sIndex in SIndeksi:
                if i == sIndex:
                    isIspunjena = False
                    break
            
            if isIspunjena: # Ovi moraju biti u RAZLICITIM timovima
                A, B = zelje[i]
                
                idA = PKMapa[nadjiRoditelja(A)]
                idB = PKMapa[nadjiRoditelja(B)]
                
                if idA == idB:
                    # Ne može
                    validanS = False
                    break
                    
                grafRazlika[idA].append(idB)
                grafRazlika[idB].append(idA) # Dodaj vezu

        if not validanS:
            continue

        boja = [ -1 ] * (velicinaGrafaRazlika + 1)
        moguceBojenje = True
        
        for i in range(1, velicinaGrafaRazlika + 1):
            if boja[i] == -1:
                # Simulacija FIFO reda za BFS (traženje puta)
                red = [i]
                glava = 0
                boja[i] = 0 # Prvi tim
                
                while glava < len(red):
                    u = red[glava]
                    glava += 1
                    
                    for v in grafRazlika[u]:
                        if boja[v] == -1:
                            boja[v] = 1 - boja[u]
                            red.append(v)
                        elif boja[v] == boja[u]:
                            # Loša boja
                            moguceBojenje = False
                            break
                    if not moguceBojenje:
                        break
            if not moguceBojenje:
                break
        
        if moguceBojenje:
            tim1Clanovi = []
            tim2Clanovi = []
            
            for clan in range(1, N + 1):
                rod = nadjiRoditelja(clan)
                idKomponente = PKMapa[rod]
                
                if boja[idKomponente] == 0:
                    tim1Clanovi.append(clan)
                else:
                    tim2Clanovi.append(clan)
            
            P = len(tim1Clanovi)
            D = len(tim2Clanovi)
            
            # vracanje kurca
            print(f"{P} {D}")
            print(*(sorted(tim1Clanovi)))
            print(*(sorted(tim2Clanovi)))
            
            resenjePronadjeno = True
            break
    
    if resenjePronadjeno:
        break
            
if not resenjePronadjeno:
    print("-1")