#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
/// globalno
int kapacitet[502][502];
int putanja[502]; 
int N, M;
long long K[502]; 
int SobaC; 
int TomovaSobaS; 


// traži put pomocu bfs
int pronadjiPutanju(int izvor, int ponor, int ukupanBrojCvorova) 
{
    memset(putanja, -1, sizeof(putanja));
    int red[502];
    int glava = 0, rep = 0;

    red[rep++] = izvor;
    putanja[izvor] = izvor;

    while (glava < rep) {
        int u = red[glava++];

        for (int v = 0; v <= ukupanBrojCvorova; v++) {
            if (putanja[v] == -1 && kapacitet[u][v] > 0) {
                putanja[v] = u;
                if (v == ponor) {
                    return 1; // Našli smo
                }
                red[rep++] = v;
            }
        }
    }
    return 0;
}

// edmodnKarp algoritam kod
long long maxFlow(int izvor, int ponor, int ukupanBrojCvorova) {
    long long protok = 0;
    
    while (pronadjiPutanju(izvor, ponor, ukupanBrojCvorova)) {
        int protokPutanja = 1000000000;
        int v = ponor;
        while (v != izvor) {
            protokPutanja = (protokPutanja < kapacitet[putanja[v]][v]) ? protokPutanja : kapacitet[putanja[v]][v];
            v = putanja[v];
        }

        v = ponor;
        while (v != izvor) {
            int u = putanja[v];
            kapacitet[u][v] -= protokPutanja; 
            kapacitet[v][u] += protokPutanja;
            v = putanja[v];
        }

        protok += protokPutanja;
    }
    return protok;
}


void resiTestPrimer() {
    int i, j;
    int A, B;

    scanf("%d %d %d", &N, &M, &SobaC);

    for (i = 1; i <= N; i++) 
    {
        scanf("%lld", &K[i]);
    }

    int hodnici[5000][2];
    for (i = 0; i < M; i++) 
    {
        scanf("%d %d", &hodnici[i][0], &hodnici[i][1]);
    }

    long long R = 0;
    for (i = 1; i <= N; i++) {
        if (K[i] > 0) {
            R += K[i];
        }
    }

    long long maxKvalitet = -1*pow(2,31); 

    for (TomovaSobaS = 1; TomovaSobaS <= N; TomovaSobaS++) {
        
        int izvor = 0; 
        int ponor = SobaC;
        int ukupanBrojCvorova = N;

        // Reset
        for (i = 0; i <= ukupanBrojCvorova; i++) {
            for (j = 0; j <= ukupanBrojCvorova; j++) {
                kapacitet[i][j] = 0;
            }
        }

        long long R_bezS = R;

        // Postavljanje cvorova
        for (i = 1; i <= N; i++) {
            if (i == TomovaSobaS)
            {
                if (K[i] > 0) {
                    R_bezS -= K[i]; // Izuzmi zaradu
                }
                continue;
            }

            if (K[i] > 0)
            {
                kapacitet[izvor][i] = K[i]; // Izvor -> Soba
            } 
            else if (K[i] < 0) 
            {
                kapacitet[i][ponor] = (int)(-K[i]); // Soba -> Ponor
            }
        }

        for (i = 0; i < M; i++) {
            A = hodnici[i][0];
            B = hodnici[i][1];
            
            if (A != TomovaSobaS && B != TomovaSobaS) {
                kapacitet[A][B] = 1000000000;
                kapacitet[B][A] = 1000000000;
            }
        }

        // max flow i min cut zvanje
        long long minCut = maxFlow(izvor, ponor, ukupanBrojCvorova);

        // finalan dobitak
        long long dobitakS = R_bezS - minCut;
        if (K[TomovaSobaS] > 0) {
            dobitakS += K[TomovaSobaS];
        }

        if (dobitakS > maxKvalitet) {
            maxKvalitet = dobitakS;
        }
    }
    
    printf("%lld\n", maxKvalitet);
}

int main() {
    int T;
    scanf("%d", &T); 

    while (T--) {
        resiTestPrimer();
    }

    return 0;
}