#include <bits/stdc++.h>
using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int T;
    cin >> T;
    while(T--){
        int N,M;
        cin >> N >> M;
        vector<long long> K(N);
        for(int i=0;i<N;i++) cin >> K[i];

        vector<vector<int>> adj(N), radj(N);
        for(int i=0;i<M;i++){
            int u,v;
            cin >> u >> v;
            adj[u].push_back(v);
            radj[v].push_back(u);
        }

        vector<bool> visited(N,false);
        vector<int> order;

        function<void(int)> dfs1 = [&](int u){
            visited[u]=true;
            for(int v:adj[u]) if(!visited[v]) dfs1(v);
            order.push_back(u);
        };

        for(int i=0;i<N;i++) if(!visited[i]) dfs1(i);

        fill(visited.begin(),visited.end(),false);
        vector<int> comp(N,-1);
        int cid=0;

        function<void(int,int)> dfs2 = [&](int u,int id){
            visited[u]=true;
            comp[u]=id;
            for(int v:radj[u]) if(!visited[v]) dfs2(v,id);
        };

        for(int i=N-1;i>=0;i--){
            int u=order[i];
            if(!visited[u]) dfs2(u,cid++);
        }

        vector<long long> sum(cid,0);
        for(int i=0;i<N;i++) sum[comp[i]]+=K[i];

        vector<bool> has_out(cid,false);
        for(int u=0;u<N;u++){
            for(int v:adj[u]){
                if(comp[u]!=comp[v]) has_out[comp[u]]=true;
            }
        }

        long long ans=-1;
        for(int i=0;i<cid;i++){
            if(!has_out[i] && sum[i]>0) ans=max(ans,sum[i]);
        }

        cout << ans << "\n";
    }
}