import sys
sys.setrecursionlimit(10**7)
from collections import deque

def solve():
    input = sys.stdin.readline
    T = int(input())
    INF = 10**18

    for _ in range(T):
        N, M = map(int, input().split())
        K = list(map(int, input().split()))

        g = [[] for _ in range(N)]
        rg = [[] for _ in range(N)]

        for _ in range(M):
            a, b = map(int, input().split())
            g[a].append(b)
            rg[b].append(a)

        used = [0]*N
        order = []

        def dfs(v):
            used[v] = 1
            for u in g[v]:
                if not used[u]:
                    dfs(u)
            order.append(v)

        for i in range(N):
            if not used[i]:
                dfs(i)

        comp = [-1]*N
        c = 0

        def rdfs(v):
            comp[v] = c
            for u in rg[v]:
                if comp[u] == -1:
                    rdfs(u)

        for v in reversed(order):
            if comp[v] == -1:
                rdfs(v)
                c += 1

        w = [0]*c
        for i in range(N):
            w[comp[i]] += K[i]

        adj = [[] for _ in range(c+2)]
        S = c
        Tt = c+1

        def add(u, v, cap):
            adj[u].append([v, cap, len(adj[v])])
            adj[v].append([u, 0, len(adj[u])-1])

        pos = 0
        for i in range(c):
            if w[i] > 0:
                add(S, i, w[i])
                pos += w[i]
            elif w[i] < 0:
                add(i, Tt, -w[i])

        for u in range(N):
            for v in g[u]:
                if comp[u] != comp[v]:
                    add(comp[u], comp[v], INF)

        level = [-1]*(c+2)

        def bfs():
            q = deque([S])
            level[:] = [-1]*(c+2)
            level[S] = 0
            while q:
                v = q.popleft()
                for to, cap, _ in adj[v]:
                    if cap > 0 and level[to] < 0:
                        level[to] = level[v] + 1
                        q.append(to)
            return level[Tt] >= 0

        def dfsf(v, f):
            if v == Tt:
                return f
            for i in range(len(adj[v])):
                to, cap, rev = adj[v][i]
                if cap > 0 and level[to] == level[v] + 1:
                    ret = dfsf(to, min(f, cap))
                    if ret:
                        adj[v][i][1] -= ret
                        adj[to][rev][1] += ret
                        return ret
            return 0

        flow = 0
        while bfs():
            while True:
                f = dfsf(S, INF)
                if not f:
                    break
                flow += f

        ans = pos - flow
        print(ans if ans > 0 else -1)