using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

public class Resenje
{
    private class Grana
    {
        public int To;
        public long Kapacitet;
        public int ReverznaGrana;
    }

    private static List<Grana>[] adj;
    private static long MaxFlow;
    private static int N_tok;

    private static void DodajGranu(int u, int v, long kapacitet)
    {
        Grana napred = new Grana { To = v, Kapacitet = kapacitet, ReverznaGrana = adj[v].Count };
        Grana nazad = new Grana { To = u, Kapacitet = 0, ReverznaGrana = adj[u].Count };

        adj[u].Add(napred);
        adj[v].Add(nazad);
    }

    private static long BFS(int s, int t, long flowLimit)
    {
        int[] parent = new int[N_tok];
        int[] parentGranaIndex = new int[N_tok];
        long[] flow = new long[N_tok];
        
        Array.Fill(parent, -1);
        Array.Fill(flow, 0);

        Queue<int> q = new Queue<int>();
        q.Enqueue(s);
        parent[s] = s;
        flow[s] = flowLimit;

        while (q.Count > 0)
        {
            int u = q.Dequeue();

            if (u == t) break;

            for (int i = 0; i < adj[u].Count; i++)
            {
                Grana grana = adj[u][i];
                int v = grana.To;

                if (parent[v] == -1 && grana.Kapacitet > 0)
                {
                    parent[v] = u;
                    parentGranaIndex[v] = i;
                    flow[v] = Math.Min(flow[u], grana.Kapacitet);
                    q.Enqueue(v);
                }
            }
        }

        if (parent[t] == -1) return 0;

        long putFlow = flow[t];
        int curr = t;
        while (curr != s)
        {
            int prev = parent[curr];
            int granaIndex = parentGranaIndex[curr];

            adj[prev][granaIndex].Kapacitet -= putFlow;
            adj[curr][adj[prev][granaIndex].ReverznaGrana].Kapacitet += putFlow;
            curr = prev;
        }
        return putFlow;
    }

    private static long EdmondsKarp(int s, int t, long totalPositiveSum)
    {
        MaxFlow = 0;
        long putFlow;
        
        while ((putFlow = BFS(s, t, totalPositiveSum)) > 0)
        {
            MaxFlow += putFlow;
        }
        return MaxFlow;
    }

    public static void Main(string[] args)
    {
        StringBuilder sb = new StringBuilder();
        if (!int.TryParse(Console.ReadLine(), out int T)) return;

        for (int t = 0; t < T; t++)
        {
            string line1 = Console.ReadLine();
            if (string.IsNullOrEmpty(line1)) continue;
            string[] nmParts = line1.Split(new char[] { ' ' }, StringSplitOptions.RemoveEmptyEntries);
            
            int N = int.Parse(nmParts[0]);
            int M = int.Parse(nmParts[1]);

            string lineK = Console.ReadLine();
            if (string.IsNullOrEmpty(lineK)) continue;
            long[] K = lineK.Split(new char[] { ' ' }, StringSplitOptions.RemoveEmptyEntries)
                            .Select(long.Parse)
                            .ToArray();

            N_tok = N + 2;
            int S_tok = 0;
            int T_tok = N + 1;
            adj = new List<Grana>[N_tok];
            for (int i = 0; i < N_tok; i++)
            {
                adj[i] = new List<Grana>();
            }

            long totalPositiveSum = 0;
            for (int i = 0; i < N; i++)
            {
                if (K[i] > 0)
                {
                    DodajGranu(S_tok, i + 1, K[i]);
                    totalPositiveSum += K[i];
                }
                else
                {
                    DodajGranu(i + 1, T_tok, -K[i]);
                }
            }
            
            long BESKONACNO = totalPositiveSum + 1;

            for (int i = 0; i < M; i++)
            {
                string edgeLine = Console.ReadLine();
                if (string.IsNullOrEmpty(edgeLine)) continue;
                string[] edgeParts = edgeLine.Split(new char[] { ' ' }, StringSplitOptions.RemoveEmptyEntries);
                
                int u = int.Parse(edgeParts[0]);
                int v = int.Parse(edgeParts[1]);
                
                DodajGranu(u + 1, v + 1, BESKONACNO); 
            }

            long maxFlow = EdmondsKarp(S_tok, T_tok, BESKONACNO);

            long maxKvalitet