#include <bits/stdc++.h>
using namespace std;
typedef long long ll;
typedef vector<ll> vi;
const ll INF = 1e18;

struct Edge {
    int to;
    ll capacity;
    int rev;
};
vector<vector<Edge>> flow_adj;
vi flow_level;
vi flow_iter;

void add_flow_edge(int from, int to, ll cap) {
    flow_adj[from].push_back({to, cap, (int)flow_adj[to].size()});
    flow_adj[to].push_back({from, 0, (int)flow_adj[from].size() - 1});
}
bool flow_bfs(int s, int t) {
    flow_level.assign(flow_adj.size(), -1);
    queue<int> q;
    flow_level[s] = 0;
    q.push(s);
    while (!q.empty()) {
        int v = q.front();
        q.pop();
        for (const auto& edge : flow_adj[v]) {
            if (edge.capacity > 0 && flow_level[edge.to] < 0) {
                flow_level[edge.to] = flow_level[v] + 1;
                q.push(edge.to);
            }
        }
    }
    return flow_level[t] != -1;
}
ll flow_dfs(int v, int t, ll f) {
    if (v == t) return f;
    for (int i = flow_iter[v]; i < flow_adj[v].size(); ++i) {
        Edge& e = flow_adj[v][i];
        if (e.capacity > 0 && flow_level[v] < flow_level[e.to]) {
            ll d = flow_dfs(e.to, t, min(f, e.capacity));
            if (d > 0) {
                e.capacity -= d;
                flow_adj[e.to][e.rev].capacity += d;
                return d;
            }
        }
    }
    return 0;
}
ll max_flow(int s, int t) {
    ll flow = 0;
    while (flow_bfs(s, t)) {
        flow_iter.assign(flow_adj.size(), 0);
        ll f;
        while ((f = flow_dfs(s, t, INF)) > 0) {
            flow += f;
        }
    }
    return flow;
}
int t, n, m;
vector<vi> adj, revadj, SCCs;
vector<bool> visited;
stack<int> st;
vi k, scc, komp;
vi sccw;

void dfs1(int u) {
    visited[u] = true;
    for (int v : adj[u]) { if (!visited[v]) dfs1(v); }
    st.push(u);
}
void dfs2(int u) {
    visited[u] = true;
    scc.push_back(u);
    for (int v : revadj[u]) { if (!visited[v]) dfs2(v); }
}

void solve() {
    scanf("%d %d", &n, &m);
    adj.assign(n, vi()), revadj.assign(n, vi()), k.assign(n, 0);
    SCCs.clear();
    while(!st.empty()) st.pop();
    for (int i = 0; i < n; i++) scanf("%lld", &k[i]);
    for (int i = 0; i < m; i++) { int u, v; scanf("%d %d", &u, &v); adj[u].push_back(v); }
    visited.assign(n, false);
    for (int i = 0; i < n; i++) { if (!visited[i]) dfs1(i); }
    for (int u = 0; u < n; u++) {
        for (int nei : adj[u]) {
            revadj[nei].push_back(u);
        }
    }
    visited.assign(n, false);
    while (!st.empty()) {
        int u = st.top();
        st.pop();
        if (!visited[u]) {
            scc.clear();
            dfs2(u);
            SCCs.push_back(scc);
        }
    }
    int num_scc = SCCs.size();
    komp.resize(n);
    for (int i = 0; i < num_scc; i++) {
        for (int u : SCCs[i]) komp[u] = i;
    }
    sccw.assign(num_scc, 0);
    for (int u = 0; u < n; u++) { sccw[komp[u]] += k[u]; }
    int s = num_scc;
    int t = num_scc + 1;
    int num_flow_nodes = num_scc + 2;
    flow_adj.assign(num_flow_nodes, vector<Edge>());
    ll P = 0;
    for (int i = 0; i < num_scc; i++) {
        ll weight = sccw[i];
        if (weight > 0) {
            P += weight;
            add_flow_edge(s, i, weight); 
        } else if (weight < 0) {
            add_flow_edge(i, t, -weight); 
        }
    }
    for (int u = 0; u < n; u++) {
        for (int v : adj[u]) {
            int comp_u = komp[u];
            int comp_v = komp[v];
            if (comp_u != comp_v) {
                add_flow_edge(comp_u, comp_v, INF);
            }
        }
    }
    ll min_cut_capacity = max_flow(s, t);
    ll max_quality = P - min_cut_capacity;
    if (max_quality > 0) {
        printf("%lld\n", max_quality);
    } else {
        printf("-1\n");
    }
}
int main() {
    scanf("%d", &t);
    while (t--) {
        solve();
    }
    return 0;
}