#include <stdio.h>
#include <stdlib.h>

#define MAXN 500
#define MAXM 1000000

int T;
int N, M;
int K[MAXN];

typedef struct {
    int to;
    int next;
} Edge;

Edge edges[MAXM];
int head[MAXN], edgeCount;

void addEdge(int u, int v) {
    edges[edgeCount].to = v;
    edges[edgeCount].next = head[u];
    head[u] = edgeCount++;
}

int index_counter;
int index[MAXN], lowlink[MAXN];
int onStack[MAXN];
int stack[MAXN], stackSize;
int sccId[MAXN], sccCount;
int sccValue[MAXN];

void tarjanDFS(int u) {
    index[u] = lowlink[u] = index_counter++;
    stack[stackSize++] = u;
    onStack[u] = 1;

    for (int i = head[u]; i != -1; i = edges[i].next) {
        int v = edges[i].to;
        if (index[v] == -1) {
            tarjanDFS(v);
            if (lowlink[v] < lowlink[u]) lowlink[u] = lowlink[v];
        } else if (onStack[v]) {
            if (index[v] < lowlink[u]) lowlink[u] = index[v];
        }
    }

    if (lowlink[u] == index[u]) {
        int v;
        int total = 0;
        do {
            v = stack[--stackSize];
            onStack[v] = 0;
            sccId[v] = sccCount;
            total += K[v];
        } while (v != u);
        sccValue[sccCount++] = total;
    }
}

int main() {
    scanf("%d", &T);
    while (T--) {
        scanf("%d %d", &N, &M);
        for (int i = 0; i < N; i++) scanf("%d", &K[i]);

        edgeCount = 0;
        for (int i = 0; i < N; i++) head[i] = -1;

        for (int i = 0; i < M; i++) {
            int u, v;
            scanf("%d %d", &u, &v);
            addEdge(u, v);
        }

        index_counter = 0;
        stackSize = 0;
        sccCount = 0;
        for (int i = 0; i < N; i++) {
            index[i] = -1;
            lowlink[i] = 0;
            onStack[i] = 0;
        }

        for (int i = 0; i < N; i++)
            if (index[i] == -1)
                tarjanDFS(i);

        int hasOut[MAXN] = {0};
        for (int u = 0; u < N; u++) {
            for (int i = head[u]; i != -1; i = edges[i].next) {
                int v = edges[i].to;
                if (sccId[u] != sccId[v])
                    hasOut[sccId[u]] = 1;
            }
        }

        int maxQuality = -1;
        for (int i = 0; i < sccCount; i++) {
            if (!hasOut[i] && sccValue[i] > 0) {
                if (sccValue[i] > maxQuality) maxQuality = sccValue[i];
            }
        }

        printf("%d\n", maxQuality);
    }
    return 0;
}