#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;
struct grana{
    int v1;
    int v2;
    int tezina;
    bool operator < (const grana& Grana) const
    {
        return tezina < Grana.tezina;
    }
    bool operator > (const grana& Grana) const
    {
        return tezina > Grana.tezina;
    }
};
struct graf
{
    vector <int> cvorovi;
    vector <grana> grane;
};
int Kruskalov (graf Graf, int M)
{
    int br = 0;
    vector <int> cvorovi = Graf.cvorovi;
    for (int i = 0; i < M; i++)
    {
        bool pretraga[2];
        pretraga[0] = binary_search (cvorovi.begin(), cvorovi.end(), Graf.grane[i].v1);
        pretraga[1] = binary_search (cvorovi.begin(), cvorovi.end(), Graf.grane[i].v2);
        if (pretraga[0]||pretraga[1])
        {
            if (pretraga[0])
            {
                auto V1 = lower_bound (cvorovi.begin(), cvorovi.end(), Graf.grane[i].v1);
                cvorovi.erase (V1, V1+1);
            }
            if (pretraga[1])
            {
                auto V2 = lower_bound (cvorovi.begin(), cvorovi.end(), Graf.grane[i].v2);
                cvorovi.erase (V2, V2+1);
            }
            br += Graf.grane[i].tezina;
        }
    }
    return br;
}
int main()
{
    graf Graf;
    int N, M;
    cin >> N >> M;
    for (int i = 0; i < N; i++)
        Graf.cvorovi.push_back (i);
    bool prost = false;
    if (N >= M) prost = true;
    if (prost)
    {
        for (int i = 0; i < M; i++)
        {
            int tezina;
            cin >> tezina;
            Graf.grane.push_back ({i, (i+1)%N, tezina});
        }
    }
    else
    {
        int holder = 0, holderSkor = 0, brojac = 0;
        bool sused = true;
        for (int i = 0; i < M; i++)
        {
            int tezina;
            cin >> tezina;
            if (sused)
            {
                Graf.grane.push_back ({brojac, (brojac+1)%N, tezina});
                brojac = (brojac+1)%N;
                if (i > 0) sused = false;
            }
            else
            {
                Graf.grane.push_back ({holder, (holderSkor+2)%N, tezina});
                if (holderSkor - 2 == N)
                {
                    holder = (holder+1)%N;
                    holderSkor = (holder+2)%N;
                }
                else holderSkor++;
                sused = true;
            }
        }
    }
    sort (Graf.grane.begin (), Graf.grane.end());
    if (M > N) cout << Kruskalov (Graf, M) << "\n";
    else
    {
        int br = 0;
        for (int i = 0; i < M; i++) br += Graf.grane[i].tezina;
        cout << br << "\n";
    }
    return 0;
}