#include <bits/stdc++.h>
using namespace std;
using ll=long long;
#define endl "\n"
///freopen("input.txt", "r", stdin);
///freopen("output.txt", "w", stdout);
const ll inf=1e18;

struct FlowEdge{
    int v,u;
    ll cap,flow=0;
    FlowEdge(int v,int u,ll cap):v(v),u(u),cap(cap){}
};

struct Dinic{
    const ll flow_inf=1e18;
    vector<FlowEdge>edges;
    vector<vector<int>>adj;
    int n,m=0,s,t;
    vector<int>level,ptr;
    queue<int>q;

    Dinic(int n,int s,int t):n(n),s(s),t(t){
        adj.resize(n);
        level.resize(n);
        ptr.resize(n);
    }

    void add_edge(int v,int u,ll cap){
        edges.emplace_back(v,u,cap);
        edges.emplace_back(u,v,0);
        adj[v].push_back(m);
        adj[u].push_back(m+1);
        m+=2;
    }

    bool bfs(){
        while(!q.empty()){
            int v=q.front();
            q.pop();
            for(int id:adj[v]){
                if(edges[id].cap==edges[id].flow)continue;
                if(level[edges[id].u]!=-1)continue;
                level[edges[id].u]=level[v]+1;
                q.push(edges[id].u);
            }
        }
        return level[t]!=-1;
    }

    ll dfs(int v,ll pushed){
        if(pushed==0)return 0;
        if(v==t)return pushed;
        for(int& cid=ptr[v];cid<adj[v].size();cid++){
            int id=adj[v][cid];
            int u=edges[id].u;
            if(level[v]+1!=level[u])continue;
            ll tr=dfs(u,min(pushed,edges[id].cap-edges[id].flow));
            if(tr==0)continue;
            edges[id].flow+=tr;
            edges[id^1].flow-=tr;
            return tr;
        }
        return 0;
    }

    ll flow(){
        ll f=0;
        while(true){
            fill(level.begin(),level.end(),-1);
            level[s]=0;
            q.push(s);
            if(!bfs())break;

            fill(ptr.begin(),ptr.end(),0);
            while(ll pushed=dfs(s,flow_inf)){
                f+=pushed;
            }
        }
        return f;
    }
};

void solve(){
    int n,m;
    cin>>n>>m;

    int s=n,t=n+1;
    Dinic dinic(n+2,s,t);

    vector<int>k(n);
    for(int i=0;i<n;i++){
        cin>>k[i];
        if(k[i]==0)continue;
        if(k[i]>0)dinic.add_edge(s,i,k[i]);
        else if(k[i]<0)dinic.add_edge(i,t,-1*k[i]);
    }

    vector<pair<int,int>>parovi(m);
    for(int i=0;i<m;i++){
        cin>>parovi[i].first>>parovi[i].second;
        dinic.add_edge(parovi[i].first,parovi[i].second,inf);
    }

    ll cut=dinic.flow(),ans=0;
    for(int i=0;i<n;i++){
        if(k[i]>0)ans+=k[i];
    }
    ans-=cut;

    if(ans<=0){
        cout<<"-1\n";
        return;
    }
    cout<<ans<<endl;
}
int main(){
    ios_base::sync_with_stdio(false);cin.tie(0);
    int t=1;
    cin>>t;
    while(t--)solve();
    return 0;
}