#include <stdio.h>
#include <stdlib.h>

#define MAXN 505
#define MAXM 1000000

int n, m;
int g[MAXN][MAXN];
int gr[MAXN][MAXN];
int gc[MAXN], grc[MAXN];

int used[MAXN], comp[MAXN];
int order[MAXN], ordn;
long long K[MAXN];
long long sum[MAXN];
int out[MAXN];

void dfs1(int v){
    used[v] = 1;
    for(int i = 0; i < gc[v]; i++){
        int to = g[v][i];
        if(!used[to]) dfs1(to);
    }
    order[ordn++] = v;
}

void dfs2(int v, int c){
    comp[v] = c;
    sum[c] += K[v];
    for(int i = 0; i < grc[v]; i++){
        int to = gr[v][i];
        if(comp[to] == -1)
            dfs2(to, c);
    }
}

int main(){
    int T;
    scanf("%d", &T);

    while(T--){
        scanf("%d %d", &n, &m);

        for(int i = 0; i < n; i++){
            scanf("%lld", &K[i]);
            gc[i] = grc[i] = 0;
            used[i] = 0;
            comp[i] = -1;
        }

        for(int i = 0; i < m; i++){
            int a, b;
            scanf("%d %d", &a, &b);
            g[a][gc[a]++] = b;
            gr[b][grc[b]++] = a;
        }

        ordn = 0;
        for(int i = 0; i < n; i++)
            if(!used[i]) dfs1(i);

        int cc = 0;
        for(int i = 0; i < n; i++)
            sum[i] = out[i] = 0;

        for(int i = n - 1; i >= 0; i--){
            int v = order[i];
            if(comp[v] == -1){
                dfs2(v, cc);
                cc++;
            }
        }

        for(int i = 0; i < n; i++){
            for(int j = 0; j < gc[i]; j++){
                int to = g[i][j];
                if(comp[i] != comp[to]){
                    out[comp[i]] = 1;
                }
            }
        }

        long long ans = -1;
        for(int i = 0; i < cc; i++){
            if(!out[i] && sum[i] > ans)
                ans = sum[i];
        }

        if(ans <= 0) ans = -1;
        printf("%lld\n", ans);
    }

    return 0;
}