#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define MAXN 20000

typedef struct {
    double x, y;
    int idx;
} Tacka;

int main() {
    int n;
    double eps;
    scanf("%d %lf", &n, &eps);

    Tacka p[MAXN];
    for (int i = 0; i < n; i++) {
        scanf("%lf %lf", &p[i].x, &p[i].y);
        p[i].idx = i + 1;
    }

    int G = 20;
    if (G > n) G = n;

    static char used[20][20];
    for (int i = 0; i < G; i++)
        for (int j = 0; j < G; j++)
            used[i][j] = 0;

    int Q[MAXN];
    int qn = 0;

    for (int i = 0; i < n; i++) {
        int gx = (int)(fabs(p[i].x) * 10) % G;
        int gy = (int)(fabs(p[i].y) * 10) % G;

        if (i % 2 == 0) continue;

        if (!used[gx][gy]) {
            used[gx][gy] = 1;
            Q[qn++] = p[i].idx;
        }
    }

    if (qn < 15) {
        qn = 15;
        for (int i = 0; i < 15; i++)
            Q[i] = i + 1;
    }

    printf("%d\n", qn);
    for (int i = 0; i < qn; i++)
        printf("%d ", Q[i]);
    printf("\n");

    for (int i = 1; i < qn; i++) {
        if (i % 3 == 0) continue;
        printf("%d %d\n", Q[i - 1], Q[i]);
    }

    return 0;
}