#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// ?????????? ???? ??????? (????)
#define MAXN 100005
#define MAXM 200005

// ???????? ????????? ?? SCC ? DAG
int N_GLOBAL, M_GLOBAL;
long long K[MAXN]; // ?????? (?) ?? ????? ????
int adj[MAXN][10]; // ????? ????????? ?? ?????????? ???? (?????????????? ???? ??????)
int adj_rev[MAXN][10]; // ??????? ???? ?? ?????????? ?????????
int adj_count[MAXN];
int adj_rev_count[MAXN];

// ????????? ?? SCC
int visited[MAXN];
int stack[MAXN], stack_top;
int scc_id[MAXN]; // SCC ????????????? ?? ????? ????
int scc_count;
long long scc_weights[MAXN]; // ?????? (????????) SCC-?

// ????????? ?? ???????????? ???? (DAG)
int dag_adj[MAXN][10];
int dag_adj_count[MAXN];
long long dp_max_k[MAXN]; // ???????????/?? ???????? ?? ????? SCC

// --- ??????? ???????? ?? ?????????? ????????? ---

// 1. ?????: DFS ?? ??????????? ?????
void dfs1(int u) {
    visited[u] = 1;
    for (int i = 0; i < adj_count[u]; i++) {
        int v = adj[u][i];
        if (!visited[v]) {
            dfs1(v);
        }
    }
    // ????? ???????? ???? ????????, ???????? ???? ?? ???? (???????????? ?????)
    stack[stack_top++] = u;
}

// 2. ?????: DFS ?? ???????? ?????
void dfs2(int u) {
    scc_id[u] = scc_count;
    // ??????????? ?????? ????? ? ???????? SCC
    scc_weights[scc_count] += K[u]; 
    visited[u] = 1;
    for (int i = 0; i < adj_rev_count[u]; i++) {
        int v = adj_rev[u][i];
        if (!visited[v]) {
            dfs2(v);
        }
    }
}

// --- ???????? ?? ????????? ???????????? ?? DAG-? ---

// ???????? ?? ?????????? ???????????? ??????????? ?????????
long long calculate_max_k(int u_scc) {
    if (dp_max_k[u_scc] != -1) {
        return dp_max_k[u_scc]; // ??????? ??????????? ?????????
    }

    long long current_max = 0;
    
    // ????????? ???? ?????? ? ????????????? ????? (DAG)
    for (int i = 0; i < dag_adj_count[u_scc]; i++) {
        int v_scc = dag_adj[u_scc][i];
        
        // ?????????? ???????? ?? ??????
        long long next_k = calculate_max_k(v_scc);
        
        // ?????? ?? ?????: ?????????? ??? ??? (????????? ????) ?? v_scc
        // ???? ??? ?? ?????? ????????? ?????.
        if (next_k > 0) {
            current_max += next_k;
        }
    }
    
    // ?????????? ???????? ?? ???? ???? ?? ?????? ???????? SCC + ?????????? ????? ?? ???? ????????
    dp_max_k[u_scc] = scc_weights[u_scc] + current_max;
    
    return dp_max_k[u_scc];
}


// --- ?????? ???????? ?? ???????? ???????? ---

void solve() {
    // ?????????? ????????? ??????? ?? ????? ???? ??????
    memset(adj_count, 0, sizeof(adj_count));
    memset(adj_rev_count, 0, sizeof(adj_rev_count));
    
    if (scanf("%d %d", &N_GLOBAL, &M_GLOBAL) != 2) return;
    
    // ????????? ?????? K
    for (int i = 0; i < N_GLOBAL; i++) {
        if (scanf("%lld", &K[i]) != 1) return;
    }
    
    // ????????? ????? ? ???????? ????? ? ???????? ?????
    for (int i = 0; i < M_GLOBAL; i++) {
        int u, v;
        if (scanf("%d %d", &u, &v) != 2) return;
        
        // ???????? ? ?????????? ???? (adj)
        adj[u][adj_count[u]++] = v;
        
        // ???????? ? ??????? ???? (adj_rev)
        adj_rev[v][adj_rev_count[v]++] = u;
    }

    // --- ?????????? ????????? ---
    
    // 1. ?????: ???? DFS ?? ???????? ????????????? ??????? (?? ?????)
    memset(visited, 0, sizeof(visited));
    stack_top = 0;
    for (int i = 0; i < N_GLOBAL; i++) {
        if (!visited[i]) {
            dfs1(i);
        }
    }
    
    // 2. ?????: ????? DFS ?? ???????? ????? ?? ??????????? SCC
    memset(visited, 0, sizeof(visited));
    memset(scc_weights, 0, sizeof(scc_weights));
    scc_count = 0;
    
    while (stack_top > 0) {
        int u = stack[--stack_top];
        if (!visited[u]) {
            scc_count++; // ???? SCC
            dfs2(u);
        }
    }
    
    // --- ???????? ????????????? ????? (DAG) ---
    
    memset(dag_adj_count, 0, sizeof(dag_adj_count));
    
    // ????????? ???? ??? ?????????? ?????
    for (int u = 0; u < N_GLOBAL; u++) {
        for (int i = 0; i < adj_count[u]; i++) {
            int v = adj[u][i];
            
            int u_scc = scc_id[u];
            int v_scc = scc_id[v];
            
            // ??? ?? ??????? ? ?????????? SCC, ??????? ????? ? DAG-?
            if (u_scc != v_scc) {
                // ???????? ????? ?? u_scc ?? v_scc.
                // ?????? ?????? ????????? ? dag_adj ?????, ??? ???? MAXN=10^5,
                // ??????????? ???????? ?? ???????????? ?? ?? ???? ????? ? DAG-? ????, 
                // ??? ????????? ????????? ?? ?????????? ????????? (???. ??? ????) ?? ????????.
                // ???? ????????? ??????????? ???????? ???? ?? ???????:
                int found = 0;
                for(int j = 0; j < dag_adj_count[u_scc]; j++) {
                    if (dag_adj[u_scc][j] == v_scc) {
                        found = 1;
                        break;
                    }
                }
                if (!found) {
                    dag_adj[u_scc][dag_adj_count[u_scc]++] = v_scc;
                }
            }
        }
    }
    
    // --- ????????? ???????????? ?? DAG-? ---

    // ??????????????? ???????????? ?????? (??)
    // -1 ???????? ?? ???????? ??? ???? ??????????
    memset(dp_max_k, -1, sizeof(dp_max_k));
    
    long long max_quality = -1;
    
    // ???????? ?? ???????? ?? ????? SCC
    for (int i = 1; i <= scc_count; i++) {
        long long current_k = calculate_max_k(i);
        
        // ??????????? ???????? ????????
        if (current_k > max_quality) {
            max_quality = current_k;
        }
    }
    
    // ??????? ????????
    if (max_quality > 0) {
        printf("%lld\n", max_quality);
    } else {
        printf("-1\n");
    }
}

int main() {
    int T;
    // ????????? ????? ???? ???????
    if (scanf("%d", &T) != 1) return 1;

    while (T--) {
        solve();
    }
    
    return 0;
}