using System;
using System.Collections.Generic;

class Program
{
    static List<int>[] g, rg;
    static bool[] used;
    static int[] comp;
    static int N, M;
    static long[] K;
    static List<int> order;

    static void Dfs1(int v)
    {
        used[v] = true;
        foreach (int u in g[v])
            if (!used[u])
                Dfs1(u);
        order.Add(v);
    }

    static void Dfs2(int v, int c)
    {
        comp[v] = c;
        foreach (int u in rg[v])
            if (comp[u] == -1)
                Dfs2(u, c);
    }

    static void Main(string[] args)
    {
        int T = int.Parse(Console.ReadLine());

        while (T-- > 0)
        {
            string[] first = Console.ReadLine().Split();
            N = int.Parse(first[0]);
            M = int.Parse(first[1]);

            K = new long[N];
            string[] ks = Console.ReadLine().Split();
            for (int i = 0; i < N; i++)
                K[i] = long.Parse(ks[i]);

            g = new List<int>[N];
            rg = new List<int>[N];
            for (int i = 0; i < N; i++)
            {
                g[i] = new List<int>();
                rg[i] = new List<int>();
            }

            for (int i = 0; i < M; i++)
            {
                string[] e = Console.ReadLine().Split();
                int a = int.Parse(e[0]);
                int b = int.Parse(e[1]);
                g[a].Add(b);
                rg[b].Add(a);
            }

            
            used = new bool[N];
            order = new List<int>();

            for (int i = 0; i < N; i++)
                if (!used[i])
                    Dfs1(i);

            comp = new int[N];
            for (int i = 0; i < N; i++)
                comp[i] = -1;

            int cCnt = 0;
            for (int i = N - 1; i >= 0; i--)
            {
                int v = order[i];
                if (comp[v] == -1)
                    Dfs2(v, cCnt++);
            }

            long[] sum = new long[cCnt];
            bool[] hasOut = new bool[cCnt];

            for (int i = 0; i < N; i++)
                sum[comp[i]] += K[i];

            for (int v = 0; v < N; v++)
            {
                foreach (int u in g[v])
                {
                    if (comp[v] != comp[u])
                        hasOut[comp[v]] = true;
                }
            }

            long ans = 0;
            for (int i = 0; i < cCnt; i++)
            {
                if (!hasOut[i] && sum[i] > 0)
                    ans += sum[i];
            }

            if (ans > 0) Console.WriteLine(ans);
            else Console.WriteLine(-1);
        }
    }
}