#include <bits/stdc++.h>
using namespace std;

const int MAXN = 505;

vector<int> g[MAXN], rg[MAXN];
bool visited[MAXN];
int comp[MAXN];
long long K[MAXN];
int N, M;

void dfs1(int u, vector<int> &order) {
    visited[u] = true;
    for (int v : g[u]) {
        if (!visited[v])
            dfs1(v, order);
    }
    order.push_back(u);
}

void dfs2(int u, int c) {
    comp[u] = c;
    for (int v : rg[u]) {
        if (comp[v] == -1)
            dfs2(v, c);
    }
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int T;
    cin >> T;

    while (T--) {
        cin >> N >> M;

        for (int i = 0; i < N; i++) {
            cin >> K[i];
            g[i].clear();
            rg[i].clear();
            visited[i] = false;
            comp[i] = -1;
        }

        for (int i = 0; i < M; i++) {
            int a, b;
            cin >> a >> b;
            g[a].push_back(b);
            rg[b].push_back(a);
        }

        vector<int> order;
        for (int i = 0; i < N; i++) {
            if (!visited[i])
                dfs1(i, order);
        }

        reverse(order.begin(), order.end());

        int sccCount = 0;
        for (int u : order) {
            if (comp[u] == -1) {
                dfs2(u, sccCount++);
            }
        }

        vector<long long> sccSum(sccCount, 0);
        vector<bool> hasOut(sccCount, false);

        for (int i = 0; i < N; i++) {
            sccSum[comp[i]] += K[i];
        }

        for (int u = 0; u < N; u++) {
            for (int v : g[u]) {
                if (comp[u] != comp[v]) {
                    hasOut[comp[u]] = true;
                }
            }
        }

        long long ans = -1;
        for (int i = 0; i < sccCount; i++) {
            if (!hasOut[i] && sccSum[i] > 0) {
                ans = max(ans, sccSum[i]);
            }
        }

        cout << ans << "\n";
    }

    return 0;
}