#include <bits/stdc++.h>
using namespace std;

struct Dinic{
    struct Edge{int to; long long cap;};
    int n;
    vector<vector<Edge>> g;
    vector<int> lvl, it;

    Dinic(int n):n(n),g(n),lvl(n),it(n){}

    void addEdge(int u,int v,long long c){
        g[u].push_back({v,c});
        g[v].push_back({u,0});
    }

    bool bfs(int s,int t){
        fill(lvl.begin(),lvl.end(),-1);
        queue<int>q;
        lvl[s]=0;q.push(s);
        while(!q.empty()){
            int u=q.front();q.pop();
            for(auto &e:g[u]){
                if(lvl[e.to]<0 && e.cap>0){
                    lvl[e.to]=lvl[u]+1;
                    q.push(e.to);
                }
            }
        }
        return lvl[t]>=0;
    }

    long long dfs(int u,int t,long long f){
        if(!f||u==t) return f;
        for(int &i=it[u];i<g[u].size();i++){
            auto &e=g[u][i];
            if(lvl[e.to]==lvl[u]+1 && e.cap>0){
                long long pushed=dfs(e.to,t,min(f,e.cap));
                if(pushed){
                    e.cap-=pushed;
                    g[e.to].back().cap+=pushed;
                    return pushed;
                }
            }
        }
        return 0;
    }

    long long maxflow(int s,int t){
        long long flow=0;
        while(bfs(s,t)){
            fill(it.begin(),it.end(),0);
            while(long long f=dfs(s,t,LLONG_MAX))
                flow+=f;
        }
        return flow;
    }
};

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int T;
    cin>>T;
    while(T--){
        int N,M;
        cin>>N>>M;

        vector<long long> K(N);
        for(int i=0;i<N;i++) cin>>K[i];

        int S=N, Tt=N+1;
        Dinic d(N+2);

        long long posSum=0;
        for(int i=0;i<N;i++){
            if(K[i]>0){
                d.addEdge(S,i,K[i]);
                posSum+=K[i];
            }else{
                d.addEdge(i,Tt,-K[i]);
            }
        }

        for(int i=0;i<M;i++){
            int a,b;
            cin>>a>>b;
            d.addEdge(a,b,LLONG_MAX);
        }

        long long cut=d.maxflow(S,Tt);
        long long ans=posSum-cut;

        if(ans<=0) cout<<-1<<"\n";
        else cout<<ans<<"\n";
    }
    return 0;
}