using System;
using System.Collections.Generic;

class Program
{
    static void Main()
    {
        int T = int.Parse(Console.ReadLine());
        var tests = new List<(int n, int m, long[] weights, List<(int, int)> edges)>();

        for (int t = 0; t < T; t++)
        {
            var nm = Console.ReadLine().Split();
            int n = int.Parse(nm[0]);
            int m = int.Parse(nm[1]);

            long[] weights = Array.ConvertAll(Console.ReadLine().Split(), long.Parse);
            var edges = new List<(int, int)>();
            for (int i = 0; i < m; i++)
            {
                var e = Console.ReadLine().Split();
                int u = int.Parse(e[0]);
                int v = int.Parse(e[1]);
                edges.Add((u, v));
            }

            tests.Add((n, m, weights, edges));
        }

        foreach (var test in tests)
        {
            int n = test.n;
            int m = test.m;
            long[] weights = test.weights;
            var edges = test.edges;

            var graph = new List<int>[n];
            for (int i = 0; i < n; i++)
                graph[i] = new List<int>();
            for (int i = 0; i < m; i++)
                graph[edges[i].Item1].Add(edges[i].Item2);

            bool[] isTerminal = new bool[n];
            for (int i = 0; i < n; i++)
                isTerminal[i] = graph[i].Count == 0;

            long[] dp = new long[n];
            bool[] visited = new bool[n];
            bool[] reachable = new bool[n];

            long DFS(int u)
            {
                if (visited[u]) return dp[u];
                visited[u] = true;

                if (isTerminal[u])
                {
                    dp[u] = weights[u];
                    reachable[u] = true;
                    return dp[u];
                }

                long best = long.MinValue;
                bool canReach = false;
                foreach (var v in graph[u])
                {
                    long res = DFS(v);
                    if (reachable[v])
                    {
                        canReach = true;
                        best = Math.Max(best, res);
                    }
                }

                if (canReach)
                {
                    dp[u] = weights[u] + best;
                    reachable[u] = true;
                }
                else
                {
                    dp[u] = long.MinValue;
                    reachable[u] = false;
                }

                return dp[u];
            }

            long answer = long.MinValue;
            for (int i = 0; i < n; i++)
            {
                long val = DFS(i);
                if (reachable[i]) answer = Math.Max(answer, val);
            }

            Console.WriteLine(answer > 0 ? answer : -1);
        }
    }
}