#include <bits/stdc++.h>
using namespace std;

struct Dinic {
    struct Edge {
        int to;
        long long cap;
        int rev;
    };

    int N;
    vector<vector<Edge>> G;
    vector<int> level, it;

    Dinic(int n) : N(n), G(n), level(n), it(n) {}

    void addEdge(int u, int v, long long cap) {
        Edge a = {v, cap, (int)G[v].size()};
        Edge b = {u, 0,   (int)G[u].size()};
        G[u].push_back(a);
        G[v].push_back(b);
    }

    bool bfs(int s, int t) {
        fill(level.begin(), level.end(), -1);
        queue<int> q;
        level[s] = 0;
        q.push(s);

        while (!q.empty()) {
            int u = q.front(); q.pop();
            for (auto &e : G[u]) {
                if (level[e.to] < 0 && e.cap > 0) {
                    level[e.to] = level[u] + 1;
                    q.push(e.to);
                }
            }
        }
        return level[t] >= 0;
    }

    long long dfs(int u, int t, long long f) {
        if (u == t) return f;
        for (int &i = it[u]; i < (int)G[u].size(); i++) {
            auto &e = G[u][i];
            if (e.cap > 0 && level[e.to] == level[u] + 1) {
                long long ret = dfs(e.to, t, min(f, e.cap));
                if (ret > 0) {
                    e.cap -= ret;
                    G[e.to][e.rev].cap += ret;
                    return ret;
                }
            }
        }
        return 0;
    }

    long long maxFlow(int s, int t) {
        long long flow = 0;
        while (bfs(s, t)) {
            fill(it.begin(), it.end(), 0);
            while (true) {
                long long pushed = dfs(s, t, LLONG_MAX);
                if (!pushed) break;
                flow += pushed;
            }
        }
        return flow;
    }
};

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int T;
    cin >> T;

    while (T--) {
        int N, M;
        cin >> N >> M;

        vector<long long> K(N);
        for (int i = 0; i < N; i++)
            cin >> K[i];

        int SRC = N;
        int SNK = N + 1;
        Dinic dinic(N + 2);

        const long long INF = (long long)1e18;
        long long sumPositive = 0;

        for (int i = 0; i < N; i++) {
            if (K[i] > 0) {
                dinic.addEdge(SRC, i, K[i]);
                sumPositive += K[i];
            } else if (K[i] < 0) {
                dinic.addEdge(i, SNK, -K[i]);
            }
        }

        for (int i = 0; i < M; i++) {
            int u, v;
            cin >> u >> v;
            dinic.addEdge(u, v, INF);
        }

        long long minCut = dinic.maxFlow(SRC, SNK);
        long long answer = sumPositive - minCut;

        cout << (answer > 0 ? answer : -1) << '\n';
    }

    return 0;
}