using System;
using System.Collections.Generic;

class Program
{
    static void Main()
    {
        var prviRed = Console.ReadLine().Trim().Split(new char[] { ' ', '\t' }, StringSplitOptions.RemoveEmptyEntries);
        int brojClanova = int.Parse(prviRed[0]);
        int brojZelja = int.Parse(prviRed[1]);
        var parovi = new List<(int, int)>();
        for (int i = 0; i < brojZelja; i++)
        {
            var delovi = Console.ReadLine().Trim().Split(new char[] { ' ', '\t' }, StringSplitOptions.RemoveEmptyEntries);
            if (delovi.Length < 2) continue; 
            int a = int.Parse(delovi[0]);
            int b = int.Parse(delovi[1]);
            parovi.Add((a, b));
        }
        HashSet<int> tim1Set = new HashSet<int>();
        HashSet<int> tim2Set = new HashSet<int>();
        foreach (var (a, b) in parovi)
        {
            if (!tim1Set.Contains(a) && !tim2Set.Contains(a))
                tim1Set.Add(a);
            if (!tim2Set.Contains(b) && !tim1Set.Contains(b))
                tim2Set.Add(b);
        }
        for (int i = 1; i <= brojClanova; i++)
        {
            if (!tim1Set.Contains(i) && !tim2Set.Contains(i))
            {
                tim2Set.Add(i);
            }
        }
        var tim1 = new List<int>(tim1Set);
        var tim2 = new List<int>(tim2Set);

        tim1.Sort();
        tim2.Sort();
        Console.WriteLine($"{tim1.Count} {tim2.Count}");
        Console.WriteLine(string.Join(" ", tim1));
        Console.WriteLine(string.Join(" ", tim2));
    }
}