using System;
using System.Linq;

public class Program
{
    private static int[] parent;

    private static int Find(int i)
    {
        if (parent[i] == i)
        {
            return i;
        }
        return parent[i] = Find(parent[i]);
    }

    private static bool Union(int i, int j)
    {
        int rootI = Find(i);
        int rootJ = Find(j);

        if (rootI != rootJ)
        {
            parent[rootI] = rootJ;
            return true;
        }
        return false;
    }

    public static void Main()
    {
        string[] lineNM = Console.ReadLine().Split();
        int N = int.Parse(lineNM[0]); 
        int M = int.Parse(lineNM[1]); 

        int[] qualities = Console.ReadLine().Split().Select(int.Parse).ToArray();

        var edges = new (int quality) [M];
        for (int i = 0; i < M; i++)
        {
            edges[i] = (qualities[i]);
        }

        Array.Sort(edges, (a, b) => b.quality.CompareTo(a.quality));

        parent = new int[N + 1];
        for (int i = 1; i <= N; i++)
        {
            parent[i] = i;
        }

        long maxSpanningTreeWeight = 0;
        int edgesCount = 0;
        if (N == 1)
        {
            Console.WriteLine(0);
            return;
        }

        for (int i = 0; i < M; i++)
        {
            if (edgesCount < N - 1)
            {
                maxSpanningTreeWeight += edges[i].quality;
                edgesCount++;
            }
            else
            {
                break;
            }
        }
        Console.WriteLine(maxSpanningTreeWeight);
    }
}