using System;
using System.Linq;

public class Program
{
    public static void Main()
    {
        string[] lineNM = Console.ReadLine().Split();
        
        if (lineNM.Length < 2)
        {
            return;
        }

        int N = int.Parse(lineNM[0]); 
        int M = int.Parse(lineNM[1]); 

        int[] qualities = Console.ReadLine().Split(new char[] { ' ' }, StringSplitOptions.RemoveEmptyEntries)
                                           .Select(int.Parse)
                                           .ToArray();

        Array.Sort(qualities, (a, b) => b.CompareTo(a));

        int requiredEdges = N - 1;
        
        if (N <= 1)
        {
            Console.WriteLine(0);
            return;
        }
        int edgesToSelect = Math.Min(requiredEdges, M);

        long maxQualitySum = 0;
        for (int i = 0; i < edgesToSelect; i++)
        {
            maxQualitySum += qualities[i];
        }

        Console.WriteLine(maxQualitySum);
    }
}