using System;
using System.IO;

class Program
{
    static void Main()
    {
        StreamReader sr = new StreamReader(Console.OpenStandardInput());
        StreamWriter sw = new StreamWriter(Console.OpenStandardOutput());

        string[] input = sr.ReadToEnd().Split(new char[] { ' ', '\n', '\r', '\t' }, StringSplitOptions.RemoveEmptyEntries);
        
        int ptr = 0;
        if (input.Length == 0) return;

        int N = int.Parse(input[ptr++]);
        int M = int.Parse(input[ptr++]);
        
        long[] A = new long[M];
        for (int i = 0; i < M; i++)
        {
            A[i] = long.Parse(input[ptr++]);
        }
        
        Array.Sort(A);
        
        long mstSum = 0;
        long nodes = 1;
        long edges = 0;
        
        for (int i = 0; i < M; i++)
        {
            long capacity = nodes * (nodes - 1) / 2;
            
            if (edges < capacity)
            {
                edges++;
            }
            else
            {
                mstSum += A[i];
                nodes++;
                edges++;
            }
        }
        
        sw.WriteLine(mstSum);
        sw.Flush();
    }
}