using System;
using System.IO;

class Program
{
    static void Main()
    {
        var buffer = new byte[1 << 16];
        int bufferIdx = 0, bufferSize = 0;
        Stream input = Console.OpenStandardInput();
        Stream output = Console.OpenStandardOutput();
        var writer = new StreamWriter(output);

        byte ReadByte()
        {
            if (bufferIdx >= bufferSize)
            {
                bufferIdx = 0;
                bufferSize = input.Read(buffer, 0, buffer.Length);
                if (bufferSize <= 0) return 0;
            }
            return buffer[bufferIdx++];
        }

        long ReadLong()
        {
            byte c = ReadByte();
            while (c <= ' ')
            {
                if (bufferSize <= 0) return -1;
                c = ReadByte();
            }
            long res = 0;
            while (c > ' ')
            {
                res = res * 10 + (c - '0');
                c = ReadByte();
            }
            return res;
        }

        long N = ReadLong();
        if (N == -1) return;
        long M = ReadLong();

        long[] A = new long[M];
        for (int i = 0; i < M; i++)
        {
            A[i] = ReadLong();
        }

        Array.Sort(A);

        long mstSum = 0;
        long nodes = 1;
        long edges = 0;

        for (int i = 0; i < M; i++)
        {
            if (nodes == N) break; 

            long capacity = nodes * (nodes - 1) / 2;

            if (edges < capacity)
            {
                edges++;
            }
            else
            {
                mstSum += A[i];
                nodes++;
                edges++;
            }
        }

        writer.WriteLine(mstSum);
        writer.Flush();
    }
}