using System;
using System.Linq;
using System.Collections.Generic;
using System.Globalization;

class Program
{
    struct Vec
    {
        public long x, y;
        public double ang;
        public int idx;
    }

    static void Main()
    {
        var input = Console.In;
        int n = int.Parse(input.ReadLine().Trim());
        var a = new Vec[n];
        for (int i = 0; i < n; i++)
        {
            var parts = input.ReadLine().Trim().Split(new[]{' ', '\t'}, StringSplitOptions.RemoveEmptyEntries);
            long x = long.Parse(parts[0], CultureInfo.InvariantCulture);
            long y = long.Parse(parts[1], CultureInfo.InvariantCulture);
            a[i].x = x;
            a[i].y = y;
            a[i].ang = Math.Atan2(y, x);
            a[i].idx = i + 1;
        }

        // Sort by angle
        Array.Sort(a, (u, v) => u.ang.CompareTo(v.ang));

        // Duplicate array with angle + 2pi
        var b = new Vec[2 * n];
        for (int i = 0; i < n; i++) b[i] = a[i];
        for (int i = 0; i < n; i++)
        {
            b[n + i] = a[i];
            b[n + i].ang = a[i].ang + 2.0 * Math.PI;
        }

        // Prefix sums of x and y
        var px = new long[2 * n + 1];
        var py = new long[2 * n + 1];
        for (int i = 0; i < 2 * n; i++)
        {
            px[i + 1] = px[i] + b[i].x;
            py[i + 1] = py[i] + b[i].y;
        }

        // Two pointers to find max length within angle window <= pi
        int r = 0;
        long bestSq = -1;
        int bestL = 0, bestR = -1; // inclusive indices in b
        for (int l = 0; l < n; l++)
        {
            if (r < l) r = l;
            while (r + 1 < 2 * n && b[r + 1].ang - b[l].ang <= Math.PI + 1e-12) r++;
            // sum from l..r
            long sx = px[r + 1] - px[l];
            long sy = py[r + 1] - py[l];
            // squared length (use unsigned 128 if needed; here use System.Numerics if overflow risk)
            // Use BigInteger to be safe for 1e18 * n
            System.Numerics.BigInteger bx = new System.Numerics.BigInteger(sx);
            System.Numerics.BigInteger by = new System.Numerics.BigInteger(sy);
            System.Numerics.BigInteger sq = bx * bx + by * by;
            if (sq > bestSq)
            {
                bestSq = (long)Math.Min((double)long.MaxValue, (double)sq); // store for comparison only
                bestL = l;
                bestR = r;
            }
        }

        // Collect indices from bestL..bestR but only those within first n entries (original indices)
        var chosen = new List<int>();
        for (int i = bestL; i <= bestR; i++)
        {
            // we only want original items (indices modulo n)
            int origIdx = b[i].idx;
            // Avoid duplicates if window crosses duplicated part: ensure we pick each original index at most once
            if (!chosen.Contains(origIdx)) chosen.Add(origIdx);
        }

        // Output
        Console.WriteLine(chosen.Count);
        if (chosen.Count > 0)
        {
            Console.WriteLine(string.Join(" ", chosen));
        }
    }
}