using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;

class FastScanner {
    private readonly Stream stream;
    private readonly byte[] buffer = new byte[1 << 16];
    private int ptr = 0, len = 0;
    public FastScanner(Stream s) { stream = s; }
    private byte Read() {
        if (ptr >= len) {
            len = stream.Read(buffer, 0, buffer.Length);
            ptr = 0;
            if (len == 0) return 0;
        }
        return buffer[ptr++];
    }
    public bool HasNext() {
        byte c;
        do { c = Read(); if (c == 0) return false; } while (c <= 32);
        ptr--;
        return true;
    }
    public int NextInt() {
        byte c;
        do { c = Read(); } while (c <= 32);
        int sign = 1;
        if (c == '-') { sign = -1; c = Read(); }
        int val = 0;
        while (c > 32) {
            val = val * 10 + (c - '0');
            c = Read();
        }
        return val * sign;
    }
}

class Program {
    static void Main() {
        var fs = new FastScanner(Console.OpenStandardInput());
        if (!fs.HasNext()) return;
        int N = fs.NextInt();
        int M = fs.NextInt();
        var edges = new (int, int)[M];
        for (int i = 0; i < M; i++) {
            int a = fs.NextInt();
            int b = fs.NextInt();
            edges[i] = (a - 1, b - 1);
        }

        int need = M / 2; // floor(M/2)
        var rnd = new Random();
        // Try multiple random partitions; expected satisfied edges = M/2.
        // Repeat enough times to get high probability of success.
        for (int iter = 0; iter < 200; iter++) {
            var assign = new bool[N];
            for (int i = 0; i < N; i++) assign[i] = (rnd.Next(2) == 1);

            int satisfied = 0;
            for (int i = 0; i < M; i++) {
                var (u, v) = edges[i];
                if (assign[u] != assign[v]) satisfied++;
            }

            if (satisfied >= need) {
                var A = new List<int>();
                var B = new List<int>();
                for (int i = 0; i < N; i++) {
                    if (assign[i]) A.Add(i + 1);
                    else B.Add(i + 1);
                }

                Console.WriteLine($"{A.Count} {B.Count}");
                if (A.Count > 0) Console.WriteLine(string.Join(" ", A));
                else Console.WriteLine();
                if (B.Count > 0) Console.WriteLine(string.Join(" ", B));
                else Console.WriteLine();
                return;
            }
        }
        Console.WriteLine("-1");
    }
}