using System;
using System.Collections.Generic;
using System.Linq;

class Solution
{
    static void Main()
    {
        var tokens = ReadAllInts();
        int idx = 0;
        int T = tokens[idx++];

        var outputs = new List<string>();
        for (int tc = 0; tc < T; tc++)
        {
            int N = tokens[idx++];
            int M = tokens[idx++];
            int P = tokens[idx++]; P--; 

            long[] K = new long[N];
            for (int i = 0; i < N; i++) K[i] = tokens[idx++];

            var adj = new List<int>[N];
            for (int i = 0; i < N; i++) adj[i] = new List<int>();
            int[] outdeg = new int[N];
            for (int i = 0; i < M; i++)
            {
                int a = tokens[idx++] - 1;
                int b = tokens[idx++] - 1;
                adj[a].Add(b);
                outdeg[a]++;
            }

            var reachable = new bool[N];
            var stack = new Stack<int>();
            stack.Push(P);
            reachable[P] = true;
            while (stack.Count > 0)
            {
                int u = stack.Pop();
                foreach (var v in adj[u])
                    if (!reachable[v])
                    {
                        reachable[v] = true;
                        stack.Push(v);
                    }
            }

            bool anySinkReachable = false;
            for (int i = 0; i < N; i++)
                if (reachable[i] && outdeg[i] == 0) anySinkReachable = true;
            if (!anySinkReachable)
            {
                outputs.Add("-1");
                continue;
            }

            int[] color = new int[N];
            bool hasCycle = false;
            var topo = new List<int>();
            Action<int> dfs = null;
            dfs = u =>
            {
                color[u] = 1;
                foreach (var v in adj[u])
                {
                    if (!reachable[v]) continue;
                    if (color[v] == 0) dfs(v);
                    else if (color[v] == 1) hasCycle = true;
                }
                color[u] = 2;
                topo.Add(u);
            };

            for (int i = 0; i < N; i++)
                if (reachable[i] && color[i] == 0) dfs(i);

            if (hasCycle)
            {
                outputs.Add("-1");
                continue;
            }

            topo.Reverse();
            long NEG = long.MinValue / 4;
            long[] dp = Enumerable.Repeat(NEG, N).ToArray();
            dp[P] = K[P];
            foreach (var u in topo)
            {
                if (dp[u] == NEG) continue;
                foreach (var v in adj[u])
                {
                    if (!reachable[v]) continue;
                    long cand = dp[u] + K[v];
                    if (cand > dp[v]) dp[v] = cand;
                }
            }

            long ans = long.MinValue;
            for (int i = 0; i < N; i++)
                if (reachable[i] && outdeg[i] == 0 && dp[i] != NEG)
                    ans = Math.Max(ans, dp[i]);

            outputs.Add(ans == long.MinValue ? "-1" : ans.ToString());
        }

        Console.Write(string.Join("\n", outputs));
    }

    static int[] ReadAllInts()
    {
        var list = new List<int>();
        string s;
        while ((s = Console.ReadLine()) != null)
        {
            if (s.Length == 0) continue;
            var parts = s.Split(new[] { ' ', '\t' }, StringSplitOptions.RemoveEmptyEntries);
            foreach (var p in parts) list.Add(int.Parse(p));
        }
        return list.ToArray();
    }
}