using System;
using System.Collections.Generic;
using System.Linq;

class Program
{
    static void Main()
    {
        string all = Console.In.ReadToEnd();
        if (string.IsNullOrWhiteSpace(all)) return;
        var parts = all.Split(new[] { ' ', '\n', '\r', '\t' }, StringSplitOptions.RemoveEmptyEntries);
        var nums = new long[parts.Length];
        for (int i = 0; i < parts.Length; i++) nums[i] = long.Parse(parts[i]);
        int idx = 0;
        int T = (int)nums[idx++];
        var outLines = new List<string>();
        for (int tc = 0; tc < T; tc++)
        {
            int N = (int)nums[idx++];
            int M = (int)nums[idx++];
            int remaining = nums.Length - idx;
            int needWithP = 1 + N + 2 * M;
            int needWithoutP = N + 2 * M;
            int P;
            if (remaining >= needWithP)
            {
                P = (int)nums[idx++] - 1;
            }
            else
            {
                P = 0;
            }
            long[] K = new long[N];
            for (int i = 0; i < N; i++) K[i] = nums[idx++];
            var adj = new List<int>[N];
            for (int i = 0; i < N; i++) adj[i] = new List<int>();
            int[] outdeg = new int[N];
            for (int i = 0; i < M; i++)
            {
                int a = (int)nums[idx++];
                int b = (int)nums[idx++];
                if (a < 0) a = 0;
                if (b < 0) b = 0;
                adj[a].Add(b);
                outdeg[a]++;
            }
            if (P < 0) P = 0;
            if (P >= N) P = 0;
            var reachable = new bool[N];
            var q = new Queue<int>();
            reachable[P] = true;
            q.Enqueue(P);
            while (q.Count > 0)
            {
                int u = q.Dequeue();
                foreach (var v in adj[u])
                    if (!reachable[v])
                    {
                        reachable[v] = true;
                        q.Enqueue(v);
                    }
            }
            bool anySink = false;
            for (int i = 0; i < N; i++) if (reachable[i] && outdeg[i] == 0) anySink = true;
            if (!anySink)
            {
                outLines.Add("-1");
                continue;
            }
            int[] indeg = new int[N];
            for (int u = 0; u < N; u++) if (reachable[u])
                foreach (var v in adj[u]) if (reachable[v]) indeg[v]++;
            var q2 = new Queue<int>();
            int reachableCount = 0;
            for (int i = 0; i < N; i++) if (reachable[i]) { reachableCount++; if (indeg[i] == 0) q2.Enqueue(i); }
            var topo = new List<int>();
            while (q2.Count > 0)
            {
                int u = q2.Dequeue();
                topo.Add(u);
                foreach (var v in adj[u]) if (reachable[v])
                {
                    indeg[v]--;
                    if (indeg[v] == 0) q2.Enqueue(v);
                }
            }
            if (topo.Count != reachableCount)
            {
                outLines.Add("-1");
                continue;
            }
            topo.Reverse();
            long NEG = long.MinValue / 4;
            var dp = Enumerable.Repeat(NEG, N).ToArray();
            dp[P] = K[P];
            foreach (var u in topo)
            {
                if (dp[u] == NEG) continue;
                foreach (var v in adj[u])
                {
                    if (!reachable[v]) continue;
                    long cand = dp[u] + K[v];
                    if (cand > dp[v]) dp[v] = cand;
                }
            }
            long ans = long.MinValue;
            for (int i = 0; i < N; i++) if (reachable[i] && outdeg[i] == 0 && dp[i] != NEG) ans = Math.Max(ans, dp[i]);
            outLines.Add(ans == long.MinValue ? "-1" : ans.ToString());
        }
        Console.Write(string.Join("\n", outLines));
    }
}