using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;

class Program
{
    class Edge
    {
        public int To;
        public long Capacity;
        public long Flow;
        public int ReverseEdge;
    }

    static List<Edge>[] graph;
    static int[] level;
    static int[] ptr;
    static int N, M;
    static int Source, Sink;

    static void AddEdge(int from, int to, long cap)
    {
        Edge forward = new Edge { To = to, Capacity = cap, Flow = 0, ReverseEdge = graph[to].Count };
        Edge backward = new Edge { To = from, Capacity = 0, Flow = 0, ReverseEdge = graph[from].Count };
        graph[from].Add(forward);
        graph[to].Add(backward);
    }

    static bool Bfs()
    {
        Array.Fill(level, -1);
        level[Source] = 0;
        Queue<int> q = new Queue<int>();
        q.Enqueue(Source);

        while (q.Count > 0)
        {
            int v = q.Dequeue();
            foreach (var edge in graph[v])
            {
                if (edge.Capacity - edge.Flow > 0 && level[edge.To] == -1)
                {
                    level[edge.To] = level[v] + 1;
                    q.Enqueue(edge.To);
                }
            }
        }
        return level[Sink] != -1;
    }

    static long Dfs(int v, long pushed)
    {
        if (pushed == 0) return 0;
        if (v == Sink) return pushed;

        for (; ptr[v] < graph[v].Count; ptr[v]++)
        {
            int id = ptr[v];
            int to = graph[v][id].To;
            if (level[v] + 1 != level[to] || graph[v][id].Capacity - graph[v][id].Flow == 0) continue;

            long tr = Dfs(to, Math.Min(pushed, graph[v][id].Capacity - graph[v][id].Flow));
            if (tr == 0) continue;

            graph[v][id].Flow += tr;
            graph[to][graph[v][id].ReverseEdge].Flow -= tr;
            return tr;
        }
        return 0;
    }

    static long Dinic()
    {
        long flow = 0;
        while (Bfs())
        {
            Array.Fill(ptr, 0);
            while (true)
            {
                long pushed = Dfs(Source, long.MaxValue);
                if (pushed == 0) break;
                flow += pushed;
            }
        }
        return flow;
    }

    static void Solve()
    {
        var input = Console.In;
        var output = Console.Out;
        
        string line = input.ReadLine();
        while (string.IsNullOrWhiteSpace(line)) line = input.ReadLine();
        int T = int.Parse(line);

        while (T-- > 0)
        {
            line = input.ReadLine();
            while (string.IsNullOrWhiteSpace(line)) line = input.ReadLine();
            var parts = line.Split(new[] { ' ' }, StringSplitOptions.RemoveEmptyEntries);
            N = int.Parse(parts[0]);
            M = int.Parse(parts[1]);

            int[] K = new int[N];
            int idx = 0;
            while (idx < N)
            {
                line = input.ReadLine();
                if (string.IsNullOrWhiteSpace(line)) continue;
                var nums = line.Split(new[] { ' ' }, StringSplitOptions.RemoveEmptyEntries);
                foreach (var num in nums)
                {
                    if (idx < N) K[idx++] = int.Parse(num);
                }
            }

            Source = 0;
            Sink = N + 1;
            graph = new List<Edge>[N + 2];
            for (int i = 0; i < N + 2; i++) graph[i] = new List<Edge>();
            level = new int[N + 2];
            ptr = new int[N + 2];

            long positiveSum = 0;

            for (int i = 0; i < N; i++)
            {
                if (K[i] > 0)
                {
                    positiveSum += K[i];
                    AddEdge(Source, i + 1, K[i]);
                }
                else if (K[i] < 0)
                {
                    AddEdge(i + 1, Sink, -K[i]);
                }
            }

            for (int i = 0; i < M; i++)
            {
                line = input.ReadLine();
                while (string.IsNullOrWhiteSpace(line)) line = input.ReadLine();
                parts = line.Split(new[] { ' ' }, StringSplitOptions.RemoveEmptyEntries);
                int u = int.Parse(parts[0]);
                int v = int.Parse(parts[1]);
                AddEdge(u + 1, v + 1, long.MaxValue);
            }

            long maxFlow = Dinic();
            long result = positiveSum - maxFlow;

            if (result > 0)
            {
                output.WriteLine(result);
            }
            else
            {
                output.WriteLine(-1);
            }
        }
        output.Flush();
    }

    static void Main(string[] args)
    {
        Solve();
    }
}