#include <bits/stdc++.h>
using namespace std;
using ll = long long;
int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int N;
    int M;
    if (!(cin >> N >> M)) return 0;
    vector<pair<int,int>> edges;
    edges.reserve(M);
    vector<vector<int>> adj(N+1);
    for (int i = 0; i < M; ++i) {
        int a,b; cin >> a >> b;
        // assume 1-indexed input
        edges.emplace_back(a,b);
        adj[a].push_back(i);
        adj[b].push_back(i);
    }

    auto count_satisfied = [&](const vector<int>& side)->int {
        int cnt = 0;
        for (auto &e : edges) if (side[e.first] != side[e.second]) ++cnt;
        return cnt;
    };

    // Randomized attempts
    std::random_device rd;
    std::mt19937 rng(rd());
    uniform_int_distribution<int> bit(0,1);

    int target = M / 2; // floor(M/2)
    vector<int> best_side(N+1, 0);
    int best_cnt = -1;

    const int TRIES = 200; // safe number of random attempts

    for (int t = 0; t < TRIES; ++t) {
        vector<int> side(N+1);
        for (int i = 1; i <= N; ++i) side[i] = bit(rng);
        int cur = count_satisfied(side);
        if (cur >= target) {
            // success: print partition
            vector<int> A, B;
            for (int i = 1; i <= N; ++i) {
                if (side[i]) A.push_back(i);
                else B.push_back(i);
            }
            cout << A.size() << " " << B.size() << "\n";
            for (size_t i = 0; i < A.size(); ++i) {
                if (i) cout << ' ';
                cout << A[i];
            }
            cout << "\n";
            for (size_t i = 0; i < B.size(); ++i) {
                if (i) cout << ' ';
                cout << B[i];
            }
            cout << "\n";
            return 0;
        }
        if (cur > best_cnt) {
            best_cnt = cur;
            best_side = side;
        }
    }

    // If random attempts failed (extremely unlikely), perform local improvement
    // Start from best_side found
    vector<int> side = best_side;
    if (best_cnt < 0) { // fallback initial if never set (M could be 0)
        for (int i = 1; i <= N; ++i) side[i] = 0;
        best_cnt = count_satisfied(side);
    }

    bool improved = true;
    int cur = best_cnt;
    // We'll do repeated passes flipping any vertex that increases satisfied count.
    // To compute delta quickly, for vertex v: delta = deg(v) - 2*diffCount (diffCount = #incident edges currently satisfied involving v)
    // We'll maintain edge satisfied boolean array to speed up.
    vector<char> edge_satisfied(M, 0);
    auto recompute_edges = [&](){
        for (int i = 0; i < M; ++i) {
            edge_satisfied[i] = (side[edges[i].first] != side[edges[i].second]);
        }
    };
    recompute_edges();

    int passes = 0;
    const int MAXPASSES = 1000; // safeguard
    while (improved && passes++ < MAXPASSES) {
        improved = false;
        for (int v = 1; v <= N; ++v) {
            int diffCount = 0;
            int deg = (int)adj[v].size();
            for (int ei : adj[v]) if (edge_satisfied[ei]) {
                // edge is currently satisfied; check if v is one of endpoints (yes) - count if satisfied and incident to v
                // The boolean indicates satisfied, but it's satisfied if side[u]!=side[v]. For an edge incident to v, that implies different.
                ++diffCount;
            }
            // But diffCount counts every incident satisfied edge; after flipping v these satisfied edges become unsatisfied,
            // and previously unsatisfied ones (deg - diffCount) become satisfied.
            int delta = (deg - diffCount) - diffCount; // = deg - 2*diffCount
            if (delta > 0) {
                // perform flip
                side[v] ^= 1;
                // update incident edges
                for (int ei : adj[v]) {
                    edge_satisfied[ei] = !edge_satisfied[ei];
                }
                cur += delta;
                improved = true;
            }
        }
    }

    if (cur >= target) {
        vector<int> A, B;
        for (int i = 1; i <= N; ++i) {
            if (side[i]) A.push_back(i);
            else B.push_back(i);
        }
        cout << A.size() << " " << B.size() << "\n";
        for (size_t i = 0; i < A.size(); ++i) {
            if (i) cout << ' ';
            cout << A[i];
        }
        cout << "\n";
        for (size_t i = 0; i < B.size(); ++i) {
            if (i) cout << ' ';
            cout << B[i];
        }
        cout << "\n";
        return 0;
    }

    // As a last resort (theoretically shouldn't happen), output -1
    cout << -1 << "\n";
    return 0;
}