#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAXN 1000000

int main() {
    int N, M;
    scanf("%d %d", &N, &M);

    int *A = (int*)malloc(M * sizeof(int));
    int *B = (int*)malloc(M * sizeof(int));
    int *team = (int*)malloc((N + 1) * sizeof(int));

    for (int i = 0; i < M; i++)
        scanf("%d %d", &A[i], &B[i]);

    int need = M / 2;

    srand(time(NULL));

    for (int attempt = 0; attempt < 200; attempt++) {

        // nasumicna podela u timove
        for (int i = 1; i <= N; i++)
            team[i] = rand() & 1;

        // broj ispunjenih želja
        int satisfied = 0;
        for (int i = 0; i < M; i++)
            if (team[A[i]] != team[B[i]])
                satisfied++;

        if (satisfied >= need) {

            // formiranje timova
            int cA = 0, cB = 0;
            for (int i = 1; i <= N; i++)
                if (team[i] == 0) cA++; else cB++;

            printf("%d %d\n", cA, cB);

            // ispis prvog tima
            for (int i = 1; i <= N; i++)
                if (team[i] == 0)
                    printf("%d ", i);
            printf("\n");

            // ispis drugog tima
            for (int i = 1; i <= N; i++)
                if (team[i] == 1)
                    printf("%d ", i);
            printf("\n");

            free(A);
            free(B);
            free(team);
            return 0;
        }
    }

    // Teoretski veoma retko se desi da ne uspemo ni posle 200 pokušaja
    printf("-1\n");

    free(A);
    free(B);
    free(team);
    return 0;
}