#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAXN 500
#define MAXM 1000000
#define INF 1000000000000LL

typedef long long ll;

/* ---------- original graph ---------- */

typedef struct {
    int to, next;
} Edge;

Edge edges[MAXM];
int head[MAXN], ecnt;

void add_edge(int u, int v) {
    edges[ecnt].to = v;
    edges[ecnt].next = head[u];
    head[u] = ecnt++;
}

/* ---------- SCC (Tarjan) ---------- */

int n, m;
int K[MAXN];

int dfn[MAXN], low[MAXN], stk[MAXN], in_stk[MAXN];
int scc_id[MAXN], scc_cnt;
int timer, top;

ll scc_sum[MAXN];

void tarjan(int u) {
    dfn[u] = low[u] = ++timer;
    stk[top++] = u;
    in_stk[u] = 1;

    for (int e = head[u]; e != -1; e = edges[e].next) {
        int v = edges[e].to;
        if (!dfn[v]) {
            tarjan(v);
            if (low[v] < low[u]) low[u] = low[v];
        } else if (in_stk[v]) {
            if (dfn[v] < low[u]) low[u] = dfn[v];
        }
    }

    if (dfn[u] == low[u]) {
        while (1) {
            int v = stk[--top];
            in_stk[v] = 0;
            scc_id[v] = scc_cnt;
            scc_sum[scc_cnt] += K[v];
            if (v == u) break;
        }
        scc_cnt++;
    }
}

/* ---------- Dinic maxflow ---------- */

typedef struct {
    int to, rev;
    ll cap;
} FlowEdge;

FlowEdge flow[2000000];
int fhead[2000], fcnt;

void add_flow_edge(int u, int v, ll c) {
    flow[fcnt] = (FlowEdge){v, fhead[u], c};
    fhead[u] = fcnt++;
    flow[fcnt] = (FlowEdge){u, fhead[v], 0};
    fhead[v] = fcnt++;
}

int level[2000], it[2000];

int bfs(int S, int T) {
    memset(level, -1, sizeof(level));
    int q[2000], ql = 0, qr = 0;
    level[S] = 0;
    q[qr++] = S;
    while (ql < qr) {
        int u = q[ql++];
        for (int e = fhead[u]; e != -1; e = flow[e].rev) {
            FlowEdge *ed = &flow[e];
            if (ed->cap > 0 && level[ed->to] < 0) {
                level[ed->to] = level[u] + 1;
                q[qr++] = ed->to;
            }
        }
    }
    return level[T] >= 0;
}

ll dfs(int u, int T, ll f) {
    if (u == T) return f;
    for (int *e = &it[u]; *e != -1; *e = flow[*e].rev) {
        FlowEdge *ed = &flow[*e];
        if (ed->cap > 0 && level[ed->to] == level[u] + 1) {
            ll ret = dfs(ed->to, T, f < ed->cap ? f : ed->cap);
            if (ret > 0) {
                ed->cap -= ret;
                flow[flow[*e].rev].cap += ret;
                return ret;
            }
        }
    }
    return 0;
}

ll maxflow(int S, int T) {
    ll res = 0;
    while (bfs(S, T)) {
        memcpy(it, fhead, sizeof(fhead));
        ll f;
        while ((f = dfs(S, T, INF)) > 0)
            res += f;
    }
    return res;
}

/* ---------- main ---------- */

int main() {
    int T;
    scanf("%d", &T);

    while (T--) {
        scanf("%d %d", &n, &m);

        for (int i = 0; i < n; i++)
            scanf("%d", &K[i]);

        for (int i = 0; i < n; i++) {
            head[i] = -1;
            dfn[i] = low[i] = in_stk[i] = 0;
        }

        ecnt = timer = top = scc_cnt = 0;
        memset(scc_sum, 0, sizeof(scc_sum));

        for (int i = 0; i < m; i++) {
            int a, b;
            scanf("%d %d", &a, &b);
            add_edge(a, b);
        }

        for (int i = 0; i < n; i++)
            if (!dfn[i]) tarjan(i);

        int S = scc_cnt;
        int Tt = scc_cnt + 1;

        memset(fhead, -1, sizeof(fhead));
        fcnt = 0;

        ll total_pos = 0;

        for (int i = 0; i < scc_cnt; i++) {
            if (scc_sum[i] > 0) {
                add_flow_edge(S, i, scc_sum[i]);
                total_pos += scc_sum[i];
            } else if (scc_sum[i] < 0) {
                add_flow_edge(i, Tt, -scc_sum[i]);
            }
        }

        for (int u = 0; u < n; u++) {
            for (int e = head[u]; e != -1; e = edges[e].next) {
                int v = edges[e].to;
                if (scc_id[u] != scc_id[v]) {
                    add_flow_edge(scc_id[u], scc_id[v], INF);
                }
            }
        }

        ll cut = maxflow(S, Tt);
        ll ans = total_pos - cut;

        if (ans > 0) printf("%lld\n", ans);
        else printf("-1\n");
    }

    return 0;
}