#include <iostream>
#include <vector>
#include <stack>
#include <algorithm>
#include <set>

using namespace std;

int main() {
    int N, M;

    cin >> N >> M;

    int granica_ispunjenih_zelja = M / 2; // koliko ih minimalno mora biti

    vector<set<int>> susedi(N, set<int>());
    vector<set<int>> zelje(N, set<int>());

    int A, B;
    for (int i = 0; i < M; i++) {
        cin >> A >> B;
        zelje[A - 1].insert(B - 1);
        susedi[A - 1].insert(B - 1);
        susedi[B - 1].insert(A - 1);
    }

    /*
    cout << "N: " << N << endl;
    cout << "M: " << M << endl;
    cout << "granica_ispunjenih_zelja: " << granica_ispunjenih_zelja << endl;
    for (int i = 0; i < N; i++) {
        for (const int& s : susedi[i]) {
            cout << "Sused cvora " << (i + 1) << ": " << (s + 1) << endl;
        }
    }
    */

    vector<int> boje(N);
    stack<int> stog;
    int boja;
    int ispunjenih_zelja;

    for (int i = 0; i < N; i++) {
        // cout << "Polazak od cvora " << (i + 1) << endl;

        ispunjenih_zelja = 0;

        stog = stack<int>();
        fill(boje.begin(), boje.end(), -1);

        stog.push(i);

        boja = 0;
        boje[i] = boja;

        while (!stog.empty()) {

            int j = stog.top();
            stog.pop();

            // susedi trenutnog cvora j treba da budu obojeni suprotnom bojom od j
            boja = 1 - boje[j];

            for (const int& sused : susedi[j]) {

                // sused je vec obojen pogresnom bojom, pa graf nije bipartitan
                if (boje[sused] != -1 && boje[sused] != boja) {
                    break;
                }

                // sused nije obojen, pa ga bojimo suprotnom bojom od tekuceg cvora j
                if (boje[sused] == -1) {
                    boje[sused] = boja;
                    stog.push(sused);

                    // Samo eksplicitno zadate zelje mogu da budu prekrsene (jednosmerno)
                    // U suprotnom smeru se ne racuna kao krsenje zelje
                    if (zelje[j].count(sused) == 1) {
                        ispunjenih_zelja++;
                        // cout << "Nova ispunjena zelja " << (j + 1) << " - " << (sused + 1) << ". Sada ih ima " << ispunjenih_zelja << endl;
                    }

                }

                if (ispunjenih_zelja >= granica_ispunjenih_zelja) {
                    // cout << "break" << endl;
                    break;
                }
                // cout << "non-break" << endl;
            }
        }

        if (ispunjenih_zelja >= granica_ispunjenih_zelja) {

            // Pronadjena je bipartitna podela!
            cout << -1;
            return 0;
            int brojP = count(boje.begin(), boje.end(), 0);
            cout << brojP << " " << (N - brojP) << endl;

            bool prvi = true;
            for (int k = 0; k < N; k++) {
                if (!prvi) cout << " ";
                if (boje[k] == 0) {
                    cout << (k + 1);
                    prvi = false;
                }
            }
            cout << endl;

            prvi = true;
            for (int k = 0; k < N; k++) {
                if (!prvi) cout << " ";
                if (boje[k] != 0) {
                    cout << (k + 1);
                    prvi = false;
                }
            }

            return 0;
        }
    }

    cout << -1;

    return 0;
}