#include <algorithm>
#include <cstdint>
#include <cstring>
#include <iostream>
#include <stack>
#include <tuple>
#include <unordered_map>
#include <vector>

typedef std::unordered_map<uint16_t, std::unordered_map<uint16_t, int16_t>> Graph;
constexpr int16_t INF = 30000;
constexpr int16_t NEG_INF = -30000;
constexpr int16_t unvisited = -1;

int main() noexcept {
  std::ios::sync_with_stdio(false);
  std::cin.tie(nullptr);
  std::cout.tie(nullptr);
  std::cerr.tie(nullptr);

	/*
	okej, zadatak ima prost tekst, trebamo
	samo da nadjemo najteži MST

	jedan nacin da ovo uradimo je da
	vecinu lakih puteva potrosimo na
	redudantne grane unutra klika ili
	grane koje bi napravile cikluse,
	i da povezemo najtezim putevima
	van njih

	
	1 <= N <= 200001
	1 <= N - 1 <= M <= N*(N-1)/2 <= 200000
	znaci imamo redak graf

	A je 1000000000, znaci 64 bita
	*/

	std::vector<int64_t> weights, prefix_sum;
  int64_t weight, redundant, avoided, max_redundant, max_possible, max_avoided,
					number_of_edges, max_weight, remaining, needed;
	int64_t i, j;
	int64_t n, m;
	std::cin >> n >> m;

	weights = std::vector<int64_t>(m);
	for(i = 0; i < m; ++i)
		std::cin >> weights[i];

	std::sort(weights.begin(), weights.end());
	// for (i = 0; i < m; ++i) std::cout << weights[i] << '\n';

	prefix_sum = std::vector<int64_t>(m+1, 0);
	for(i = 1; i <= m; ++i)
		prefix_sum[i] = prefix_sum[i - 1] + weights[i - 1];

	max_weight = 0;
	redundant = m - (n - 1);
	for(i = 1; i <= n; ++i) {
		max_possible = i*(i-1)/2;
		max_avoided = max_possible - (i - 1);
		// ako dobijemo negativno
		max_avoided = std::max(max_avoided, static_cast<int64_t>(0));
		// kolko mozemo da ubacimo dodatne grane
		// unutra jednu grupu
		avoided = std::min(redundant, max_avoided);

		number_of_edges = (i - 1) + avoided;
		if(number_of_edges > m) continue; // vise nego moguce
		
		// prvih obaveznih i - 1 najmanjih
		//for(j = 0, weight = 0; j < i - 1; ++j)
		//	weight += weights[j];
		weight = prefix_sum[i - 1];

		// za ostali cvorovi nam treba n - i onda
		// a ostaju nam m - number_of_edges grana
		needed = n - i;
		remaining = m - number_of_edges;
		if(needed > remaining) continue; // ako nam treba vise nego sto imamo
																		 // onda je takodje ne moguce
		//for(j = 0; j < needed; ++j)
		//	weight += weights[number_of_edges + j];
		weight += prefix_sum[number_of_edges + needed] - prefix_sum[number_of_edges];

		max_weight = std::max(max_weight, weight);
	}
	std::cout << max_weight << '\n';
}