#include <algorithm>
#include <cstdint>
#include <cstring>
#include <iostream>
#include <stack>
#include <tuple>
#include <unordered_map>
#include <vector>

typedef std::unordered_map<uint16_t, std::unordered_map<uint16_t, int16_t>> Graph;
constexpr int16_t INF = 30000;
constexpr int16_t NEG_INF = -30000;
constexpr int16_t unvisited = -1;

constexpr uint16_t MAX_N = 1001; // jer krecemo od 1
constexpr uint32_t MAX_M = (MAX_N)*(MAX_N-1);

// static bool team[MAX_N]; // ima da stavimo unutra funkcije da bi
// ostao sa random garbage values, jer bi inace izgubili mnogo vreme
// na inicijalne interacije gde je sve nula, ili bi izgubili vreme
// tako sto stavljamo random values
// ipak garbage values prave problemi jer se
// tim ne racuna ni kao true ni false
// pa ih brzo randomizujem sa true false
static bool matrix[MAX_N][MAX_N];

constexpr bool LEFT = false;
constexpr bool RIGHT = true;

static uint8_t should_switch(const uint16_t n, 
														 const bool (&team)[MAX_N], 
														 const uint16_t node) {
	const bool node_team = team[node];
	int16_t counter = 0;

	// idemo kroz svaku zelju i ako imamo
	// vise protivnici na suprotan tim se
	// ne menjamo, ako imamo vise na nas tim
	// onda se menjamo
	for(uint16_t i = 1; i < n; ++i)
		if (matrix[node][i])
			counter += (node_team != team[i])? 1 : -1;

	return (counter < 0);
}

int main() noexcept {
  std::ios::sync_with_stdio(false);
  std::cin.tie(nullptr);
  std::cout.tie(nullptr);
  std::cerr.tie(nullptr);
	
	bool team[MAX_N];

	uint32_t m, mj;
	uint16_t n, a, b, i, p, d;
	bool has_switched_once, current_switch;

	std::cin >> n >> m;
	++n; ++m;

	// prvo randomizujemo timove
	for (i = 0; i < n; ++i)
		team[i] = (i&1)? true : false;

	for(mj = 1; mj < m; ++mj) {
		std::cin >> a >> b;
		matrix[a][b] = matrix[b][a] = true;
	}

	while(true) {
		has_switched_once = false;
		for(i = 1; i < n; ++i)
			if(should_switch(n, team, i)) {
				has_switched_once = true;
				team[i] = !team[i];
			}
		if(!has_switched_once)
			break;
	}
	
	for (i = 1, p = 0, d = 0; i < n; ++i)
		if(team[i])
			++p;
		else
			++d;
	std::cout << p << ' ' << d << '\n';

	for (i = 1; i < n; ++i)
		if(team[i])
			std::cout << i << ' ';
	std::cout << '\n';

	for (i = 1; i < n; ++i)
		if(!team[i])
			std::cout << i << ' ';
	std::cout << '\n';
	// prakticno znam da je uvek moguce da
	// se dobije rešenje jer sam probao
	// program koji samo ispise -1 i dobio
	// sam nula tacni primera
}