#include <algorithm>
#include <cstdint>
#include <cstring>
#include <iostream>
#include <stack>
#include <tuple>
#include <unordered_map>
#include <vector>

typedef std::unordered_map<uint16_t, std::unordered_map<uint16_t, int16_t>> Graph;
constexpr int16_t INF = 30000;
constexpr int16_t NEG_INF = -30000;
constexpr int16_t unvisited = -1;

constexpr uint16_t MAX_N = 500;
constexpr uint32_t MAX_M = MAX_N*(MAX_N-1)/2;

[[gnu::hot]] [[gnu::pure]]
static int64_t sum_from(const std::vector<int16_t>& tree, 
												const std::vector<int16_t>& value,
												int16_t it) {
	int64_t sum = 0;
	for(;it != -1; it = tree[it])
		sum += value[it];
	return sum;
}

int main() noexcept {
  std::ios::sync_with_stdio(false);
  std::cin.tie(nullptr);
  std::cout.tie(nullptr);
  std::cerr.tie(nullptr);

	std::vector<int16_t> tree; // 1d jer u stablu jedan cvor moze samo
														  // da pokazuje na jedan drugi cvor
	std::vector<int16_t> milk;
	int64_t max_sum, sum;
	uint32_t m, i;
	uint16_t n, a, b;
	uint16_t t, ti;

	tree.reserve(MAX_N);
	milk.reserve(MAX_N);

	std::cin >> t; // jebeno ga racuna kao char kad
								 // je uint8 zaboravio sam na to 
	for(ti = 0; ti < t; ++ti) {
		std::cin >> n >> m;

		milk.resize(n);
		for(i = 0; i < n; ++i)
			std::cin >> milk[i];

		tree.resize(n);
		std::fill(tree.begin(), tree.end(), -1);
		for(i = 0; i < m; ++i) {
			std::cin >> a >> b;
			tree[b] = a; // ako stavim [b] = a onda je obrnuto stablo
		} 					   // pa bi svi listovi bili koreni

		// probamo svaki cvor kao da je on list
		max_sum = INT64_MIN;
		for(i = 0; i < n; ++i) {
			sum = sum_from(tree, milk, static_cast<int16_t>(i));
			if(sum > 0)
				max_sum = std::max(max_sum, sum);
		}

		std::cout << ((max_sum != INT64_MIN) ? max_sum : -1) << '\n';
	}
}