using System;
using System.Collections.Generic;

class Program
{
    static void Main()
    {
        var nm = Console.ReadLine().Split();
        int N = int.Parse(nm[0]);
        int M = int.Parse(nm[1]);

        List<int>[] G = new List<int>[N + 1];
        for (int i = 1; i <= N; i++) G[i] = new List<int>();

        var EDGES = new List<(int, int)>();

        for (int i = 0; i < M; i++)
        {
            var s = Console.ReadLine().Split();
            int a = int.Parse(s[0]);
            int b = int.Parse(s[1]);
            G[a].Add(b);
            G[b].Add(a);
            EDGES.Add((a, b));
        }

        int[] COLOR = new int[N + 1];
        Array.Fill(COLOR, -1);

        for (int i = 1; i <= N; i++)
        {
            if (COLOR[i] != -1) continue;

            Queue<int> Q = new Queue<int>();
            COLOR[i] = 0;
            Q.Enqueue(i);

            while (Q.Count > 0)
            {
                int u = Q.Dequeue();
                foreach (int v in G[u])
                {
                    if (COLOR[v] == -1)
                    {
                        COLOR[v] = COLOR[u] ^ 1;
                        Q.Enqueue(v);
                    }
                }
            }
        }

        int CUT = 0;
        foreach (var (a, b) in EDGES)
            if (COLOR[a] != COLOR[b]) CUT++;

        if (CUT < M - CUT)
        {
            for (int i = 1; i <= N; i++)
                COLOR[i] ^= 1;
        }

        List<int> A = new List<int>();
        List<int> B = new List<int>();

        for (int i = 1; i <= N; i++)
        {
            if (COLOR[i] == 0) A.Add(i);
            else B.Add(i);
        }

        Console.WriteLine($"{A.Count} {B.Count}");
        Console.WriteLine(string.Join(" ", A));
        Console.WriteLine(string.Join(" ", B));
    }
}