#include <iostream>
#include <algorithm>

using namespace std;

pair<int, int> osobe[1000];
int zelje[1000][1000];

int main() {
    int n, m;
    cin >> n >> m;

    for (int i = 0; i<m; i++) {
        int x, y;
        cin >> x >> y;
        x--; y--;
        
        if (zelje[x][y]) {   
            continue;
        }

        osobe[x].first++;
        osobe[y].first++;
        zelje[x][y] = 1;
        zelje[y][x] = 1;
    }

    if (n == 1) {
        cout << -1;
        return 0;
    }

    if (m == 0) {
        cout << "1 " << n-1 << "\n";
        cout << 1 << "\n";
        for (int i = 2; i<=n; i++) cout << i << " ";
        return 0;
    }

    for (int i = 0; i<n; i++) {
        osobe[i].second = i;
    }

    sort(osobe, osobe + n, greater<pair<int, int>>());

    int pocetak = 0, ispunjeno = 0, m_pola = (m <= 1 ? 1 : m/2);
    while (pocetak < n && ispunjeno < m_pola) {
        pocetak++;
        
        ispunjeno += osobe[pocetak-1].first;

        for (int i = 0; i<pocetak-1; i++) {
            ispunjeno -= 2*zelje[osobe[i].second][osobe[pocetak-1].second];
        }
    }

    if (pocetak >= n || ispunjeno < m_pola) {
        cout << -1;
        return 0;
    }

    cout << pocetak << " " << n - pocetak << "\n";
    for (int i = 0; i<pocetak; i++)
        cout << osobe[i].second + 1 << " ";
    cout << "\n";
    for (int i = pocetak; i<n; i++)
        cout << osobe[i].second + 1 << " ";

    return 0;
}