import sys
sys.setrecursionlimit(10000)

def kosaraju_scc(n, adj):
    visited = [False]*n
    order = []
    def dfs(u):
        visited[u] = True
        for v in adj[u]:
            if not visited[v]:
                dfs(v)
        order.append(u)
    for u in range(n):
        if not visited[u]:
            dfs(u)
    
    # ??????? ????
    radj = [[] for _ in range(n)]
    for u in range(n):
        for v in adj[u]:
            radj[v].append(u)
    
    comp = [0]*n
    visited = [False]*n
    def rdfs(u, label):
        visited[u] = True
        comp[u] = label
        for v in radj[u]:
            if not visited[v]:
                rdfs(v,label)
    
    label = 0
    for u in reversed(order):
        if not visited[u]:
            rdfs(u,label)
            label += 1
    return comp, label  # comp[i]=id SCC-?, label=???? SCC

T = int(input())
for _ in range(T):
    N,M = map(int,input().split())
    K = list(map(int,input().split()))
    adj = [[] for _ in range(N)]
    for _ in range(M):
        u,v = map(int,input().split())
        adj[u].append(v)
    
    comp, ncomp = kosaraju_scc(N,adj)
    
    # ???? ??????? ? ?????? SCC
    comp_sum = [0]*ncomp
    for i in range(N):
        comp_sum[comp[i]] += K[i]
    
    # ????????? ?? ?? SCC ???? ?????
    out_deg = [0]*ncomp
    for u in range(N):
        for v in adj[u]:
            if comp[u] != comp[v]:
                out_deg[comp[u]] += 1
    
    res = -1
    for i in range(ncomp):
        if out_deg[i]==0 and comp_sum[i]>0:
            res = max(res, comp_sum[i])
    print(res)