from collections import defaultdict
import sys
sys.setrecursionlimit(10000)

def tarjan_scc(n, edges):
    index = 0
    indices = [-1]*n
    lowlink = [0]*n
    on_stack = [False]*n
    stack = []
    sccs = []

    def strongconnect(v):
        nonlocal index
        indices[v] = lowlink[v] = index
        index += 1
        stack.append(v)
        on_stack[v] = True

        for w in edges[v]:
            if indices[w] == -1:
                strongconnect(w)
                lowlink[v] = min(lowlink[v], lowlink[w])
            elif on_stack[w]:
                lowlink[v] = min(lowlink[v], indices[w])

        if lowlink[v] == indices[v]:
            scc = []
            while True:
                w = stack.pop()
                on_stack[w] = False
                scc.append(w)
                if w == v:
                    break
            sccs.append(scc)

    for v in range(n):
        if indices[v] == -1:
            strongconnect(v)
    return sccs

T = int(input())
for _ in range(T):
    N, M = map(int, input().split())
    K = list(map(int, input().split()))
    edges = [[] for _ in range(N)]
    for _ in range(M):
        a,b = map(int, input().split())
        edges[a].append(b)

    sccs = tarjan_scc(N, edges)
    max_quality = -1

    for scc in sccs:
        is_sink = True
        quality = sum(K[i] for i in scc)
        for u in scc:
            for v in edges[u]:
                if v not in scc:
                    is_sink = False
                    break
            if not is_sink:
                break
        if is_sink and quality > 0:
            max_quality = max(max_quality, quality)
    print(max_quality)