import sys
import threading
sys.setrecursionlimit(10**7)

def main():
    input = sys.stdin.readline
    T = int(input())
    
    for _ in range(T):
        N, M = map(int, input().split())
        K = list(map(int, input().split()))
        
        edges = [[] for _ in range(N)]
        for _ in range(M):
            u, v = map(int, input().split())
            edges[u].append(v)
        
        index = 0
        indices = [-1]*N
        lowlink = [0]*N
        on_stack = [False]*N
        stack = []
        SCCs = []
        
        def strongconnect(v):
            nonlocal index
            indices[v] = index
            lowlink[v] = index
            index += 1
            stack.append(v)
            on_stack[v] = True
            
            for w in edges[v]:
                if indices[w] == -1:
                    strongconnect(w)
                    lowlink[v] = min(lowlink[v], lowlink[w])
                elif on_stack[w]:
                    lowlink[v] = min(lowlink[v], indices[w])
            
            if lowlink[v] == indices[v]:
                # Found an SCC
                scc = []
                while True:
                    w = stack.pop()
                    on_stack[w] = False
                    scc.append(w)
                    if w == v:
                        break
                SCCs.append(scc)
        
        for v in range(N):
            if indices[v] == -1:
                strongconnect(v)
        
        max_quality = -1
        
        for scc in SCCs:
            is_sink = True
            for u in scc:
                for v in edges[u]:
                    if v not in scc:
                        is_sink = False
                        break
                if not is_sink:
                    break
            quality = sum(K[u] for u in scc)
            if is_sink and quality > 0:
                max_quality = max(max_quality, quality)
        
        print(max_quality)

# ?? ???? ????? ? ????????? ????????? threading
threading.Thread(target=main).start()